<?php
/******************************************************************************************
* $Id: view.html.php 79 2011-04-02 16:01:50Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access');
jimport("joomla.application.component.view");

class JvleViewJvle extends JView
{
    var $tvar = array();
//***************************************************************************************************     
    function display($tpl = null)
    {
        $layout = JRequest::getVar('layout');
        switch ($layout)
        {
            case 'emailappr': $this->processEmailAction($tpl); break;
            case 'addlink': $this->drawAddLinkForm($tpl); break;
            case 'addbanner': $this->drawAddBannerForm($tpl); break;
            case 'all_links': $this->drawAllLinksinCategory($tpl); break;
            case 'links': $this->drawCategoryPage($tpl); break;
            default: $this->drawDirectoryHomePage($tpl); break;
        }
    }
//***************************************************************************************************         
    function drawDirectoryHomePage($tpl)
    {
        $cfg = JvleCfg::getInstance();

        require_once(JPATH_COMPONENT_SITE.DS.'templates'.DS._JVLE_TEMPLATE.DS.'index.php');
        $tmpl = new JvleTemplate(_JVLE_TEMPLATE);
        $tmpl->setMetaData(JText::_("COM_JVLE_A149"), JText::_("COM_JVLE_A150"), JText::_("COM_JVLE_A151"));
                
        $this->assignRef('cfg', $cfg);
        $this->assignRef('tmpl', $tmpl);
 
        $document =& JFactory::getDocument();        
        $document->addStyleSheet(_MOS_LIVESITE."components/com_jvle/templates/default/style.css");
        parent::display($tpl);        
    }
//***************************************************************************************************         
    function drawCategoryPage($tpl)
    {
        $cfg = JvleCfg::getInstance();
        $cid = JRequest::getInt('cid', 0);

        require_once(JPATH_COMPONENT_SITE.DS.'templates'.DS._JVLE_TEMPLATE.DS.'index.php');
        $tmpl = new JvleTemplate(_JVLE_TEMPLATE);
        
        $obj = JvleDb::getRow("select name, description from #__jvle_categories where id = '".(int)$cid."'");
        $keywords = JString::str_ireplace("{CATNAME}", $obj->name, JText::_("COM_JVLE_A152"));
        $tmpl->setMetaData($obj->name, $keywords, $obj->description);
        
        $links =& $this->get('Data');
        $pagination =& $this->get('Pagination');        
                
        $this->assignRef('cfg', $cfg);
        $this->assignRef('tmpl', $tmpl);
        $this->assignRef('links', $links);
        $this->assignRef('pagination', $pagination);
        $this->assignRef('cid', $cid);
 
        $document =& JFactory::getDocument();        
        $document->addStyleSheet(_MOS_LIVESITE."components/com_jvle/templates/default/style.css");
        parent::display($tpl);        
    }
//***************************************************************************************************           
    function drawAllLinksinCategory($tpl)
    {
        $cfg = JvleCfg::getInstance();
        $cid = JRequest::getInt('cid', 0);
        
        require_once(JPATH_COMPONENT_SITE.DS.'templates'.DS._JVLE_TEMPLATE.DS.'index.php');
        $tmpl = new JvleTemplate(_JVLE_TEMPLATE);
        
        $obj = JvleDb::getRow("select name, description from #__jvle_categories where id = '".(int)$cid."'");
        $keywords = JString::str_ireplace("{CATNAME}", $obj->name, JText::_("COM_JVLE_A152"));
        $tmpl->setMetaData($obj->name, $keywords, $obj->description);        
        
        $sby = JRequest::getInt('sby', 11);
        $ord = "desc";
        if ($sby < 0)
        {
            $ord = "asc";
            $sby = 0 - $sby;
        }

        $links = JvleDb::getRows("select * from #__jvle_links where link_category = '".(int)$cid."' and link_status != 'REJECTED' order by ".(int)$sby." ".$ord);
                
        $this->assignRef('cfg', $cfg);
        $this->assignRef('tmpl', $tmpl);
        $this->assignRef('links', $links);
        $this->assignRef('cid', $cid);
 
        $document =& JFactory::getDocument();  
        $document->addStyleSheet(_MOS_LIVESITE."components/com_jvle/templates/default/style.css");
        parent::display($tpl); 
    }
//***************************************************************************************************
    function drawAddLinkForm($tpl)         
    {
        $cfg = JvleCfg::getInstance();
        
        require_once(JPATH_COMPONENT_SITE.DS.'templates'.DS._JVLE_TEMPLATE.DS.'index.php');
        $tmpl = new JvleTemplate(_JVLE_TEMPLATE);        
                     
        $c_id = $c_name = $c_cpid = $c_alink = array();
        JvleUtil::getCategories(0, $c_id, $c_name, $c_cpid, $c_alink);
        
        $error = 0;
        $dispmsg = '';
        try
        {
            if (!$cfg->fe_addlink)
                throw new Exception(JText::_("COM_JVLE_A29"));
            
            if (!count($c_id))
                throw new Exception(JText::_("COM_JVLE_A28"));
            
            $mode = JRequest::getInt('mode', 0);
            if ($mode)
            {
                $model =& $this->getModel();
                
                $retmsg = '';
                $ret = $model->addWebsite(1, $retmsg);
                if (!$ret)
                    throw new Exception($retmsg);
                else
                    $dispmsg = $retmsg;
            }
        }
        catch (Exception $ex)
        {
            $error = 1;
            $dispmsg = $ex->getMessage();
            $nextpage = JRoute::_('index.php?option=com_jvle&Itemid='._JVLE_ITEMID.'&task=addlink');
        }
        
        $this->assignRef('cfg', $cfg);
        $this->assignRef('tmpl', $tmpl);
        $this->assignRef('dispmsg', $dispmsg);
        $this->assignRef('error', $error);
        $this->assignRef('c_id', $c_id);
        $this->assignRef('c_name', $c_name);
        $this->assignRef('c_cpid', $c_cpid);
        $this->assignRef('c_alink', $c_alink);
        $this->assignRef('npage', $nextpage); 
        
        $tmpl->setMetaData(JText::_("COM_JVLE_A53"), JText::_("COM_JVLE_A153"));
        
        $document =& JFactory::getDocument();  
        $document->addStyleSheet(_MOS_LIVESITE."components/com_jvle/templates/default/style.css");
        parent::display($tpl);               
    }

    function drawAddBannerForm($tpl)         
    {
        $cfg = JvleCfg::getInstance();
        
        require_once(JPATH_COMPONENT_SITE.DS.'templates'.DS._JVLE_TEMPLATE.DS.'index.php');
        $tmpl = new JvleTemplate(_JVLE_TEMPLATE);        
                     
        $c_id = $c_name = $c_cpid = $c_alink = array();
        JvleUtil::getCategories(0, $c_id, $c_name, $c_cpid, $c_alink);
        
        $error = 0;
        $dispmsg = '';
        try
        {
            if (!$cfg->fe_addbanner)
                throw new Exception(JText::_("COM_JVLE_A29"));
            
            if (!count($c_id))
                throw new Exception(JText::_("COM_JVLE_A28"));
            
            $mode = JRequest::getInt('mode', 0);
            if ($mode)
            {
                $model =& $this->getModel();
                                
                $retmsg = '';
                $ret = $model->addWebsite(0, $retmsg);
                if (!$ret)
                    throw new Exception($retmsg);
                else
                    $dispmsg = $retmsg;
            }                                         
        }
        catch (Exception $ex)
        {
            $error = 1;
            $dispmsg = $ex->getMessage();
            $nextpage = JRoute::_('index.php?option=com_jvle&Itemid='._JVLE_ITEMID.'&task=addbanner');
        }
        
        $this->assignRef('cfg', $cfg);        
        $this->assignRef('dispmsg', $dispmsg);
        $this->assignRef('error', $error);
        $this->assignRef('c_id', $c_id);
        $this->assignRef('c_name', $c_name);
        $this->assignRef('c_cpid', $c_cpid); 
        $this->assignRef('c_alink', $c_alink);
        $this->assignRef('tmpl', $tmpl);
        $this->assignRef('npage', $nextpage);
        
        $tmpl->setMetaData(JText::_("COM_JVLE_A54"), JText::_("COM_JVLE_A154"));
        
        $document =& JFactory::getDocument();  
        $document->addStyleSheet(_MOS_LIVESITE."components/com_jvle/templates/default/style.css");
        parent::display($tpl);             
    }
    
    function processEmailAction($tpl)
    {
        $cfg = JvleCfg::getInstance();
        
        require_once(JPATH_COMPONENT_SITE.DS.'templates'.DS._JVLE_TEMPLATE.DS.'index.php');
        $tmpl = new JvleTemplate(_JVLE_TEMPLATE);        
                     
        try
        {
            $act = JRequest::getInt('act', -1);            
            $emstr = JRequest::getString('emstr', '');
            if (($act == -1) || ($emstr == ''))
                throw new Exception(JText::_("COM_JVLE_A29"));
            
            $link = JvleDb::getRow("select * from #__jvle_links where emstr = '".JvleSecure::defendSQL($emstr)."'");    
            if (!$link)
                throw new Exception(JText::_("COM_JVLE_A29"));
            
            if ($act)
            {
                if ($link->link_status == 'ESTABLISHED')
                    throw new Exception(JText::_("COM_JVLE_A101"));
                
                if ($link->link_status != 'PENDING')
                    throw new Exception(JText::_("COM_JVLE_A119"));
                
                if (!JvleDb::update("update #__jvle_links set link_status = 'ESTABLISHED', link_added_on = '".time()."', link_published_on = '".time()."' where emstr = '".JvleSecure::defendSQL($emstr)."'"))
                    throw new Exception(JText::_("COM_JVLE_A120"));
                
                $ploc = _MOS_LIVESITE."index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=all_category_links&cid=".$link->link_category;    
                $em_msg = str_replace("{P-LOC}", $ploc, str_replace("{MY-EMAIL}", $cfg->self_email, str_replace("{MY-URL}", $cfg->self_url, JText::_("COM_JVLE_A108"))));
                JvleUtil::sendEmail($link->partner_email, JText::_("COM_JVLE_A112"), $em_msg);

                $dispmsg = JText::_("COM_JVLE_A121");
            }
            else
            {
                if ($link->link_status == 'REJECTED')
                    throw new Exception(JText::_("COM_JVLE_A122"));
                
                if ($link->link_status != 'PENDING')
                    throw new Exception(JText::_("COM_JVLE_A119"));
                
                if (!JvleDb::update("update #__jvle_links set link_status = 'REJECTED' where emstr = '".JvleSecure::defendSQL($emstr)."'"))
                    throw new Exception(JText::_("COM_JVLE_A120"));
                
                $em_msg = str_replace("{REASON}", $cfg->generic_reject_reason, str_replace("{MY-EMAIL}", $cfg->self_email, str_replace("{MY-URL}", $cfg->self_url, JText::_("COM_JVLE_A123"))));
                JvleUtil::sendEmail($link->partner_email, JText::_("COM_JVLE_A124"), $em_msg);

                $dispmsg = JText::_("COM_JVLE_A125");                
            }
        }
        catch (Exception $ex)
        {
            $dispmsg = $ex->getMessage();
        }
        
        $this->assignRef('cfg', $cfg);        
        $this->assignRef('dispmsg', $dispmsg);
        $this->assignRef('tmpl', $tmpl);
        
        $document =& JFactory::getDocument();  
        $document->addStyleSheet(_MOS_LIVESITE."components/com_jvle/templates/default/style.css");
        parent::display($tpl);                     
    }
}