<?php
/******************************************************************************************
* $Id: functions.php 107 2011-07-07 10:25:24Z sniranjan $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
//****************************************************************************************
class JvleTemplateUtil
{
    function drawCategoryBlock($maincat, $subcats)
    {
        $out = '';
        $out .= JvleTemplateUtil::drawCategoryInfo($maincat, 0).'<br />';
        if (count($subcats))
        {
            $subcat_info = '';
            foreach ($subcats as $subcat)
                $subcat_info .= JvleTemplateUtil::drawCategoryInfo($subcat, 1).", ";

            $subcat_info = JString::substr($subcat_info, 0, JString::strlen($subcat_info)-2);
            $out .= $subcat_info.'<br />';
        }
        
        return $out;  
    }
    
    function drawCategoryInfo($category, $level)        
    {
        $out = '';
        
        $classname = ($level) ? "jvle_subcatrow" : "jvle_maincatrow";
        $display_name = JvleUtil::getCategoryName($category->id);        
        $catdesc = ($category->description != '') ? stripslashes($category->description) : $display_name;
        $numlinks = JvleUtil::getNumlinks($category->id, 0);
        $pagelnk = JRoute::_("index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=links&cid=".$category->id);
        
        if (!$category->accept_links && !$numlinks)
            $out .= '<font class="'.$classname.'"><span class="editlinktip hasTip" title="'.htmlspecialchars($catdesc).'">'.$display_name.'</span></font>';
        else
            $out .= '<font class="'.$classname.'"><span class="editlinktip hasTip" title="'.htmlspecialchars($catdesc).'"><a href="'.$pagelnk.'">'.$display_name.'</a></span></font>';
            
        if ($numlinks)
            $out .= '&nbsp;('.$numlinks.')';        
        
        return $out;
    }
    
    function getPartnerLinkURL($link) 
    {
    	$cfg = JvleCfg::getInstance();
    	
    	if (($link->link_type == "ONE-WAY") && ($cfg->track_hits))
    		return JRoute::_("index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=redirect&id=".$link->id);
    	
    	return $link->partner_url;
    }
    
    function drawLinkInfo($link, $bgmode=0, $pg)
    {                
        $bgcolor = ($bgmode == 1) ? "jvle_linkrow_color" : "jvle_linkrow_nocolor";
        $cfg = JvleCfg::getInstance();        
        $window = JvleUtil::getTargetString(); /* DG:3 */
        $snap = JvleSiteUtil::loadWebsnap($link->link_category, $link->snap_status);
        
        $thumb = new JvleThumbnail($cfg, $link->partner_url);
        $thumbnail = $thumb->getThumbnail($pg);
         
        $ratinginfo = JvleTemplateUtil::showRatingInfo($link);
        $width_1 = ($ratinginfo == '') ? "100%" : "80%";         
         
        $out = '';
        
        $out .= '   <table width="100%" cellpadding="5" cellspacing="0" border="1px solid #DDDDDD">'; /* DG:2 */
        $out .= '   <tr>
                        <td valign="top" width="'.$width_1.'" class="'.$bgcolor.'">'.$thumbnail;
        
        if ($link->exchange_link)
        {
            $out .= '       <span class="jvle_linktitle"><a'.$window.$snap.' href="'.JvleTemplateUtil::getPartnerLinkURL($link).'">'.stripslashes($link->partner_title).'</a></span>';
            if ($link->partner_desc != '')
                $out .= '   <span class="jvle_linkdesc">'.stripslashes($link->partner_desc).'</span><br />';
        }
        else
        {
            $out .= '       <a'.$window.$snap.' href="'.JvleTemplateUtil::getPartnerLinkURL($link).'"><img src='._MOS_BANNERS.$link->banner_loc.' border="0" alt="'.stripslashes($link->partner_title).'" /></a><br />';                        
        }            
        
        $out .= '       </td>';
        $out .=    '	<td valign="top" width="20%" align="center"  class="'.$bgcolor.'" style="text-align:center;">';
        
        if (($link->link_type == "ONE-WAY") && ($cfg->track_hits))
		{
        	$out .= 	JText::_("COM_JVLE_A146").": <strong>".$link->hits."</strong><br />";
        }
             
        if ($ratinginfo != '')
        {
            $out .= 		$ratinginfo;
        }
        
        $out .= 	'	</td>';
        $out .=     '</tr>';
        $out .= '   </table>';
        return $out;
    }

    function showRatingInfo($link)
    {
        $cfg = JvleCfg::getInstance();            
        if (!$cfg->enable_link_rating) return '';
        
        $out = '';
        if ($cfg->display_ratings) {
            $out .= JText::_("COM_JVLE_A147").": <strong>".$link->num_votes."</strong><br />";
            $out .= JText::_("COM_JVLE_A148").": <strong>".round($link->link_rating, 2)."</strong><br />";
        }
                        
        $user =& JFactory::getUser();
        if (($cfg->link_rating_by == "all") || (($cfg->link_rating_by == "registered") && ($user->get('id')))) 
        {
        	if (_JVLE_J16)
        		JHTML::_('behavior.framework');
        	else
        		JHTML::_('behavior.mootools');
        	        	
        	$tempstr = "<img src='"._MOS_IMGDIR."ajax-loader.gif' style='margin-right:2px;' alt=''/>";
            $randnum = $link->id.rand(0,9999);
            $voteAjaxQuery = '
                    /* <![CDATA[ */
                    window.addEvent("domready", function() {
	            		document.id("rating'.$randnum.'").addEvent("change", function(e) {
	            		e.stop();
	            		var url = "'._MOS_LIVESITE.'index.php?option=com_jvle";
	            		var rating = this.get("value");
	            		var req = new Request({
	            			url: url,
	            			method: "post",
							onRequest: function() {
                            	document.id("ratingcont'.$randnum.'").set("html", "'.$tempstr.'");
                            },	            			
	            			onSuccess: function(response) {
	            				document.id("ratingcont'.$randnum.'").set("html", "");
	            				document.id("rating'.$randnum.'").disabled = true;
	            				alert(response);
	            			}
	            		}).send("task=rate&lid='.$link->id.'&rating="+rating+"&format=raw");
	            	});
	            });
            	/* ]]> */';

            $document =& JFactory::getDocument();
            $document->addScriptDeclaration($voteAjaxQuery);                     
            
            $out .= '<form name="rform'.$randnum.'" method="get" action="'._MOS_LIVESITE.'index.php?option=com_jvle&amp;Itemid='._JVLE_ITEMID.'&amp;task=rate&amp;lid='.$link->id.'">';
            $out .= '<select id="rating'.$randnum.'" name="rating'.$randnum.'" class="jvle_listbox" style="font-size: 85%;margin-top:1em;">';
            $out .= '   <option value="0" selected="selected">'.JText::_("COM_JVLE_A58").'</option>';
            $out .= '   <option value="5">5 - '.JText::_("COM_JVLE_A65").'</option>';
            $out .= '   <option value="4">4</option>';
            $out .= '   <option value="3">3</option>';
            $out .= '   <option value="2">2</option>';
            $out .= '   <option value="1">1 - '.JText::_("COM_JVLE_A66").'</option>';            
            $out .= '</select>';            
            $out .= "<div id='ratingcont".$randnum."'></div>";
            $out .= '</form>';
        }
        
        return $out;
    }    
}