<?php
/******************************************************************************************
* $Id: index.php 109 2011-07-07 11:05:54Z sniranjan $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
//****************************************************************************************
JHTML::_('behavior.tooltip');

class JvleTemplate
{
    var $cfg;
    var $name;
    
    function __construct($tmplname)
    {
        $this->cfg = JvleCfg::getInstance();    
        $this->name = $tmplname;
    }
    
    function setMetaData($pagetitle, $metakeys, $metadesc='') {
    	$keywords = (is_array($metakeys)) ? implode(",",$metakeys) : $metakeys;
    	
    	$document =& JFactory::getDocument();
    	$document->setTitle($pagetitle);
    	$document->setMetaData('keywords', $keywords);
    	$document->setMetaData('description', (($metadesc == '') ? $pagetitle : $metadesc));
    }    
    
    function getName()
    {
        return $this->name;
    }
    
    function getImagePath()
    {
        return _MOS_LIVESITE."/components/com_jvle/templates/".$this->name."/images/";
    }
    
    function drawHeader()
    {
?>
<div id="jvle_header">
    <h1 id="logotext"><?php echo stripslashes($this->cfg->fe_title); ?></h1>
    <h2 id="slogan"><?php echo stripslashes($this->cfg->header_slogan); ?></h2>
</div>
<?php
    }
    
    function drawMenu()
    {
        $lnk = JRoute::_("index.php?option=com_jvle&Itemid="._JVLE_ITEMID);
?>
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<tr>
    <td width="70%" style="text-align:left;">
        <a href="<?php echo $lnk; ?>"><?php echo JText::_("COM_JVLE_A49"); ?></a>
<?php
        if ($this->cfg->fe_addlink) 
        {
            $lnk = JRoute::_("index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=addlink");
?>
        &nbsp;&nbsp;|&nbsp;&nbsp;<a href="<?php echo $lnk; ?>" title="<?php echo JText::_("COM_JVLE_A53"); ?>"><?php echo JText::_("COM_JVLE_A53"); ?></a>
<?php        
    }
?>    
<?php
        if ($this->cfg->fe_addbanner) 
        {
            $lnk = JRoute::_("index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=addbanner");
?>
        &nbsp;&nbsp;|&nbsp;&nbsp;<a href="<?php echo $lnk; ?>" title="<?php echo JText::_("COM_JVLE_A54"); ?>"><?php echo JText::_("COM_JVLE_A54"); ?></a>
<?php        
        }
?>    
<?php
        if ($this->cfg->enable_checklinkstatus) 
        {
            $lnk = JRoute::_("index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=checklinkstatus");
?>
        &nbsp;&nbsp;|&nbsp;&nbsp;<a href="<?php echo $lnk; ?>" title="<?php echo JText::_("COM_JVLE_A55"); ?>"><?php echo JText::_("COM_JVLE_A55"); ?></a>
<?php        
        }
?>    
<?php
        if ($this->cfg->enable_recweb) 
        {
            $lnk = JRoute::_("index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=recommend");
?>
        &nbsp;&nbsp;|&nbsp;&nbsp;<a href="<?php echo $lnk; ?>" title="<?php echo JText::_("COM_JVLE_A56"); ?>"><?php echo JText::_("COM_JVLE_A56"); ?></a>
<?php        
        }
?>    
    </td>
    <td width="30%">
<?php
        if ($this->cfg->enable_search) 
        {
?>    
    <form action="<?php echo _MOS_LIVESITE.'index.php?option=com_jvle&Itemid='._JVLE_ITEMID; ?>" method="post" class="jvle_search">
    <p>
        <input type="text" name="query" size="20" value="<?php echo JText::_("COM_JVLE_A126"); ?>" maxlength="20" onblur="if (this.value == '') this.value='<?php echo JText::_("COM_JVLE_A126"); ?>';" onfocus="if (this.value=='<?php echo JText::_("COM_JVLE_A126"); ?>') this.value='';" />
    </p> 
    <input type="hidden" name="task" value="search" />
    <input type="hidden" name="option" value="com_jvle" />
    <input type="hidden" name="mode" value="1" />
    </form>
<?php
        }
?>
    </td>
</tr>
<?php
        if (($this->cfg->enable_ads) && ($this->cfg->ad_top != ''))
        {
?>
<tr>
    <td colspan="2"><br /><?php echo stripslashes($this->cfg->ad_top); ?><br /></td>
</tr>    
<?php
        }
?>
</table>        
<?php
    }    
    
    function drawFooter()
    {
?>
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<?php
        if (($this->cfg->enable_ads) && ($this->cfg->ad_bottom != ''))
        {
?>
<tr>
    <td><br /><?php echo stripslashes($this->cfg->ad_bottom); ?><br /></td>
</tr>    
<?php
        }
?>

<tr>
    <td style="text-align:center" height="30" valign="bottom"><small>
        <a href="http://www.jv-extensions.com" target="_blank"><?php echo JText::_("COM_JVLE_A57"); ?></a>
    </small><br /></td></tr>
</table>
<?php
    }    
    
    function drawDirectoryHome()
    {
?>
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<?php
        if ($this->cfg->fe_dir_summary != '')
        {
?>
<tr>
    <td><?php echo str_replace("\n", "<br />", stripslashes($this->cfg->fe_dir_summary)); ?><br /><br /></td>
</tr>    
<?php
        }
?>    

<tr>
    <td>
        <div id="jvle_dirmodel">
<?php
        $x=1;
        $maincats = JvleDb::getRows("select * from `#__jvle_categories` where `cpid` = '0' and `visibility` = '1' order by `name` asc");
        foreach ($maincats as $maincat)
        {
            $subcats = JvleDb::getRows("select * from `#__jvle_categories` where `cpid` = '".(int)$maincat->id."' and `visibility` = '1' order by `name` asc");
            if ($x%2)
            {
?>
            <div class="jvle_dirmodel_lb"><?php echo JvleTemplateUtil::drawCategoryBlock($maincat, $subcats); ?></div>
<?php            
            }
            else
            {
?>
            <div class="jvle_dirmodel_rb"><?php echo JvleTemplateUtil::drawCategoryBlock($maincat, $subcats); ?></div>
            <div class="jvle_clear"></div>
<?php            
            }
            
            $x++;
        }
        if (!($x%2))                                
        {
?>
                <div class="jvle_dirmodel_rb">&nbsp;</div>
                <div class="jvle_clear"></div>
<?php        
        }    
?>    
        </div>
    </td>
</tr> 

<?php
        if ($this->cfg->fe_instructions != '')
        {
?>
<tr>
    <td><?php echo str_replace("\n", "<br />", stripslashes($this->cfg->fe_instructions)); ?><br /></td>
</tr>    
<?php
        }
?>

<?php
        if ($this->cfg->show_latest_links)
        {
            $latlinks = JvleDb::getRows("select * from #__jvle_links where link_status = 'ESTABLISHED' order by link_published_on desc limit 0, 5");
?>
<tr>
    <td><?php echo $this->drawLatestLinks($latlinks); ?></td>
</tr>    
<?php
        }
?>
</table>
<?php
    }    

    function drawCategoryLinks($obj)
    {
?>
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A63").' '.JvleUtil::getCategoryName($obj->cid); ?></h1>
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<tr>
    <td colspan="2">
<?php
        if (count($obj->links))
        {            
            $mode = 1;
            foreach ($obj->links as $link)
                echo JvleTemplateUtil::drawLinkInfo($link, ($mode++%2), _JVLE_GENCATEGORY_PAGE);    
        }
        else
        {
?>
            <p style="text-align:center;height:30px;"><?php echo JText::_("COM_JVLE_A67"); ?></p>
<?php
        }
?>
    </td>
</tr>
<?php 
        if (count($obj->links)) 
        {
            $baseurl = "index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=links&cid=".$obj->cid;
            $allurl = JRoute::_("index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=all_category_links&cid=".$obj->cid);
?>    
<tr>
    <td width="75%" style="text-align:center;"><?php echo $obj->pagination->getPagesLinks($baseurl); ?></td>
    <td width="25%" style="text-align:right;"><a href="<?php echo $allurl; ?>"><?php echo JText::_("COM_JVLE_A69"); ?></a></td>
</tr>
<?php
        }

        if ($this->cfg->show_latest_links == 2)
        {
            $latlinks = JvleDb::getRows("select * from #__jvle_links where link_status = 'ESTABLISHED' order by link_published_on desc limit 0, 5");
?>
<tr>
    <td colspan="2"><?php echo $this->drawLatestLinks($latlinks); ?></td>
</tr>    
<?php
        }
?>
</table>
<?php
    }    

    function drawCategoryAllLinks($obj)
    {
        $sby = JRequest::getInt('sby', 11);
        
        /* DG:7-S */
        $stexts = array(JText::_("COM_JVLE_A71"), JText::_("COM_JVLE_A72"), JText::_("COM_JVLE_A75"), JText::_("COM_JVLE_A76"));
        $svalues = array(-3,-11,3,11);
        if ($this->cfg->enable_link_rating) {
            array_push($stexts, JText::_("COM_JVLE_A73"), JText::_("COM_JVLE_A74"), JText::_("COM_JVLE_A77"), JText::_("COM_JVLE_A78"));
            array_push($svalues, -12,-13,12,13);
        }
        /* DG:7-F */     
?>
<script type="text/javascript">
function showAllLinks(objs)
{
    document.location.href = "<?php echo _MOS_LIVESITE; ?>index.php?option=com_jvle&amp;Itemid=<?php echo _JVLE_ITEMID; ?>&amp;task=all_category_links&amp;cid=<?php echo $obj->cid; ?>&amp;sby="+objs.value;
}
</script>
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A62").' '.JvleUtil::getCategoryName($obj->cid); ?></h1>
<table width="100%" cellspacing="0" cellpadding="2" align="center" class="jvle_mainborder">
<tr>
    <td>
        <form name="f1" method="get" action="<?php echo _MOS_LIVESITE.'index.php?option=com_jvle&Itemid='._JVLE_ITEMID; ?>">
        <p style="text-align:right;"><?php echo JText::_("COM_JVLE_A70"); ?>: <?php echo JvleUtil::showSelectTag('sby', $sby, $stexts, $svalues, "class='jvle_sortlist' onchange='javascript:showAllLinks(this);'"); ?></p> <?php /* DG:7 */ ?>
        </form>
    </td>
</tr>    
<tr>
    <td>
<?php
        if (count($obj->links))
        {            
            $mode = 1;
            foreach ($obj->links as $link)
                echo JvleTemplateUtil::drawLinkInfo($link, ($mode++%2), _JVLE_GENCATEGORY_PAGE);                   
        }
        else
        {
?>
            <p style="text-align:center;height:30px;"><?php echo JText::_("COM_JVLE_A67"); ?></p>
<?php
        }
?>
    </td>
</tr>
<?php
        if ($this->cfg->show_latest_links == 2)
        {
            $latlinks = JvleDb::getRows("select * from #__jvle_links where link_status = 'ESTABLISHED' order by link_published_on desc limit 0, 5");
?>
<tr>
    <td><?php echo $this->drawLatestLinks($latlinks); ?></td>
</tr>    
<?php
        }
?>
</table>
<?php
    }
    
    function drawLatestLinks($links)
    {
?>        
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A60"); ?></h1>
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<tr>
    <td>
<?php
        if (count($links))
        {            
            $mode = 1;
            foreach ($links as $link)
                echo JvleTemplateUtil::drawLinkInfo($link, ($mode++%2), _JVLE_LATLINKS_PAGE);            
        }
        else
        {
?>
            <p style="text-align:center;height:30px;"><?php echo JText::_("COM_JVLE_A68"); ?></p>
<?php
        }
?>
    </td>
</tr>
</table>
<?php        
    }

    function drawFeaturedLinks()
    {
        if (!$this->cfg->enable_flinks || !$this->cfg->show_flinks) return '';
        
        $flink_url = JRoute::_("index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=addfeatured");
            
        $sql = "select * from #__jvle_links where featured = '1' and link_status = 'ESTABLISHED' order by ";
        $sql .= ($this->cfg->flinks_dtype == 'recent') ? " link_published_on " : " RAND() ";
        $sql .= " desc limit 0, ".$this->cfg->flinks_numshow;
        $flinks = JvleDb::getRows($sql);
?>        
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A61"); ?></h1>
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_flinktable">
<tr>
    <td>
<?php
        $mode = 1;
        foreach ($flinks as $link)
            echo JvleTemplateUtil::drawLinkInfo($link, ($mode++%2), _JVLE_FEATUREDLINK_PAGE);   
?>
    </td>
</tr>
<tr><td style="text-align:right;"><a href="<?php echo $flink_url; ?>" title="<?php echo JText::_("COM_JVLE_A64"); ?>"><?php echo JText::_("COM_JVLE_A64"); ?></a></td></tr>
</table>
<?php        
    }

    
    function drawSearchResults($obj)
    {
?>        
<h1 class="jvle_h1"><?php echo str_replace("{QUERY}", htmlspecialchars($obj->query), JText::_("COM_JVLE_A84")); ?></h1>
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<tr>
    <td>
<?php
        if ($obj->errmsg != '')
        {
?>
            <p style="text-align:center;height:30px;"><?php echo $obj->errmsg; ?></p>
<?php            
        }
        else
        {
            if (count($obj->links))
            {            
                $mode = 1;
                foreach ($obj->links as $link)
                    echo JvleTemplateUtil::drawLinkInfo($link, ($mode++%2), _JVLE_SEARCHRESULTS_PAGE);                    
            }
            else
            {
?>
                <p style="text-align:center;height:30px;"><?php echo JText::_("COM_JVLE_A85"); ?></p>
<?php
                
            }
        }
?>
    </td>
</tr>
<?php 
    if (($obj->errmsg == '') && count($obj->links)) { 
        $baseurl = "index.php?option=com_jvle&Itemid="._JVLE_ITEMID."&task=search&query=".htmlspecialchars($obj->query); /* DG:1 */
?>
<tr>
    <td style="text-align:center;"><?php echo $obj->pagination->getPagesLinks($baseurl); ?></td>
</tr>
<?php } ?>
</table>
<?php        
    }               
    
    function drawChecklinkstatusForm($obj)
    {
?>
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A43"); ?></h1>
<form name="clform" method="post" action="<?php echo _MOS_LIVESITE.'index.php?option=com_jvle&Itemid='._JVLE_ITEMID; ?>">        
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JText::_("COM_JVLE_A42"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="" name="siteurl" maxlength="80" size="40" /><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A39")); ?></td>    
</tr>    
<?php echo JvleSiteUtil::showCaptchaForm(JText::_("COM_JVLE_A41")); ?>   
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right">&nbsp;</td>
    <td height="25" width="70%" valign="top"><input type="submit" name="submit1" value="<?php echo JText::_("COM_JVLE_A40"); ?>" /></td>    
</tr>    
</table>
<input type="hidden" name="option" value="com_jvle" />
<input type="hidden" name="task" value="checklinkstatus" />
<input type="hidden" name="mode" value="1" />
</form>
<?php        
    }               

    function drawRecommendsiteForm($obj)
    {
?>
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A38"); ?></h1>
<form name="rsform" method="post" action="<?php echo _MOS_LIVESITE.'index.php?option=com_jvle&Itemid='._JVLE_ITEMID; ?>">        
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<?php            
        if ($this->cfg->recommend_site_intro != '')
        {
?>
<tr>
    <td colspan="2"><?php echo str_replace("\n", "<br />", stripslashes($this->cfg->recommend_site_intro)); ?><br /></td>
</tr>    
<?php
        }
?>
<tr><td colspan="2">&nbsp;</td></tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JText::_("COM_JVLE_A37"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="" name="name" maxlength="80" size="40" /></td>    
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JText::_("COM_JVLE_A36"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="" name="email" maxlength="80" size="40" /></td>    
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JText::_("COM_JVLE_A35"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="" name="siteurl" maxlength="80" size="40" /><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A39")); ?></td>    
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JText::_("COM_JVLE_A34"); ?></td>
    <td height="25" width="70%" valign="top"><textarea name="reason" rows="10" cols="35"></textarea></td>    
</tr>
<?php echo JvleSiteUtil::showCaptchaForm(JText::_("COM_JVLE_A41")); ?>   
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right">&nbsp;</td>
    <td height="25" width="70%" valign="top"><input type="submit" name="submit1" value="<?php echo JText::_("COM_JVLE_A40"); ?>" /></td>    
</tr>    
</table>
<input type="hidden" name="option" value="com_jvle" />
<input type="hidden" name="task" value="recommend" />
<input type="hidden" name="mode" value="1" />
</form>
<?php        
    }               

    function drawAddLinkForm($obj)
    {
        $session =& JFactory::getSession();    /* DG:5 */
        $info = '<a href="'.$this->cfg->self_url.'" title="'.htmlspecialchars($this->cfg->self_title).'" target="_blank">'.htmlspecialchars($this->cfg->self_title).'</a><br />'.htmlspecialchars($this->cfg->self_desc); 
?>
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A27"); ?></h1>
<form name="alform" method="post" action="<?php echo _MOS_LIVESITE.'index.php?option=com_jvle&Itemid='._JVLE_ITEMID; ?>">        
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<?php            
        if ($this->cfg->fe_newlink_summary != '')
        {
?>
<tr>
    <td colspan="2"><?php echo str_replace("\n", "<br />", stripslashes($this->cfg->fe_newlink_summary)); ?><br /></td>
</tr>    
<?php
        }
?>
<tr><td colspan="2"><strong><?php echo JText::_("COM_JVLE_A26"); ?></strong></td></tr>
<tr><td colspan="2"><strong><?php echo JText::_("COM_JVLE_A25"); ?></strong></td></tr>
<tr><td colspan="2">
    <table cellpadding="2" cellspacing="0" width="80%" align="center" style="border:1px solid #e1e2e3;">
    <tr>
        <td width="30%" class="jvle_code"><strong><?php echo JText::_("COM_JVLE_A23"); ?></strong></td>
        <td width="70%" class="jvle_code"><?php echo stripslashes($this->cfg->self_url); ?></td>
    </tr>
    <tr>
        <td width="30%" class="jvle_code"><strong><?php echo JText::_("COM_JVLE_A24"); ?></strong></td>
        <td width="70%" class="jvle_code"><?php echo stripslashes($this->cfg->self_title); ?></td>
    </tr>
    <tr><td colspan="2" class="jvle_code"><strong><?php echo JText::_("COM_JVLE_A22"); ?></strong></td></tr>
    <tr><td colspan="2" class="jvle_code"><?php echo stripslashes($this->cfg->self_desc); ?></td></tr>
    </table>
</td></tr>
<tr><td colspan="2" style="text-align: center;"><?php echo JText::_("COM_JVLE_A21"); ?></td></tr>
<tr><td colspan="2"><strong><?php echo JText::_("COM_JVLE_A20"); ?></strong></td></tr>
<tr><td colspan="2">
    <table cellpadding="2" cellspacing="0" width="80%" align="center" style="border:1px solid #e1e2e3;">
    <tr><td colspan="2" class="jvle_code"><?php echo htmlentities($info, ENT_COMPAT, "UTF-8"); ?></td></tr>
    </table>
</td></tr>
<tr><td colspan="2">&nbsp;</td></tr>
<tr><td colspan="2" style="text-align: center;"><strong><?php echo JText::_("COM_JVLE_A19").'<br />'.JText::_("COM_JVLE_A18"); ?></strong></td></tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JvleUtil::showRequired(); ?><?php echo JText::_("COM_JVLE_A14"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="<?php echo $session->get('purl', '', 'aform'); ?>" name="purl" maxlength="200" size="40" /><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A9")); ?></td>    <?php /* DG:5 */ ?>
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JvleUtil::showRequired(); ?><?php echo JText::_("COM_JVLE_A17"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="<?php echo $session->get('pemail', '', 'aform'); ?>" name="pemail" maxlength="100" size="40" /><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A6")); ?></td>    <?php /* DG:5 */ ?>
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JvleUtil::showRequired(); ?><?php echo JText::_("COM_JVLE_A15"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="<?php echo $session->get('ptitle', '', 'aform'); ?>" name="ptitle" maxlength="80" size="40" /><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A8")); ?></td>    <?php /* DG:5 */ ?>
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JText::_("COM_JVLE_A13"); ?></td>
    <td height="25" width="70%" valign="top"><textarea name="pdesc" rows="10" cols="35"><?php echo $session->get('pdesc', '', 'aform'); ?></textarea><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A10")); ?></td>   <?php /* DG:5 */ ?> 
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JvleUtil::showRequired(); ?><?php echo JText::_("COM_JVLE_A16"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="<?php echo $session->get('prurl', '', 'aform'); ?>" name="prurl" maxlength="200" size="40" /><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A7")); ?></td>   <?php /* DG:5 */ ?> 
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JvleUtil::showRequired(); ?><?php echo JText::_("COM_JVLE_A12"); ?></td>
    <td height="25" width="70%" valign="top">
    <select name="pcat">
        <?php 
        for ($i=0;$i<count($obj->c_id);$i++)  
        {
            $selected = ($obj->c_id[$i] == $session->get('pcat', 0, 'aform')) ? "selected=selected" : ""; /* DG:5 */
            $levext = ($obj->c_cpid[$i]) ? '........' : '';
            $disabled = ($obj->c_alink[$i]) ? '' : 'disabled="disabled"';    
        ?>
        <option <?php echo $disabled; ?> value="<?php echo $obj->c_id[$i]; ?>" <?php echo $selected; ?>><?php echo $levext.' '.stripslashes(JvleUtil::getCategoryName($obj->c_id[$i])); ?></option> <?php /* DG:5 */ ?>
        <?php    
        }
        ?>
    </select><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A11")); ?>
    </td>    
</tr>
<?php echo JvleSiteUtil::showCaptchaForm(JText::_("COM_JVLE_A41")); ?>   
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right">&nbsp;</td>
    <td height="25" width="70%" valign="top"><input type="submit" name="submit1" value="<?php echo JText::_("COM_JVLE_A40"); ?>" /></td>    
</tr>    
</table>
<input type="hidden" name="option" value="com_jvle" />
<input type="hidden" name="task" value="addlink" />
<input type="hidden" name="mode" value="1" />
</form>
<?php        
    }     

    function drawBannerForm($obj)
    {
        $session =& JFactory::getSession();  /* DG:5 */
        $info = '<a href="'.$this->cfg->self_url.'" title="'.htmlspecialchars($this->cfg->self_url).'" target="_blank"><img src="'.$this->cfg->banner_loc.'" border="0" alt="'.htmlspecialchars($this->cfg->self_url).'" /></a>'; 
?>
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A86"); ?></h1>
<form name="abform" method="post" action="<?php echo _MOS_LIVESITE.'index.php?option=com_jvle&Itemid='._JVLE_ITEMID; ?>" enctype="multipart/form-data">        
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<?php            
        if ($this->cfg->fe_newbanner_summary != '')
        {
?>
<tr>
    <td colspan="2"><?php echo str_replace("\n", "<br />", stripslashes($this->cfg->fe_newbanner_summary)); ?><br /></td>
</tr>    
<?php
        }
?>
<tr><td colspan="2"><strong><?php echo JText::_("COM_JVLE_A87"); ?></strong></td></tr>
<tr><td colspan="2"><strong><?php echo JText::_("COM_JVLE_A88"); ?></strong></td></tr>
<tr><td colspan="2">
    <table cellpadding="2" cellspacing="0" width="80%" align="center" style="border:1px solid #e1e2e3;">
    <tr>
        <td width="30%" class="jvle_code"><strong><?php echo JText::_("COM_JVLE_A23"); ?></strong>:</td>
        <td width="70%" class="jvle_code"><?php echo stripslashes($this->cfg->self_url); ?></td>
    </tr>
    <tr><td colspan="2" class="jvle_code"><?php echo JText::_("COM_JVLE_A89"); ?></td></tr>
    <tr><td colspan="2" class="jvle_code"><img src="<?php echo $this->cfg->banner_loc; ?>" border="0" alt="<?php echo htmlspecialchars($this->cfg->self_url); ?>" /></td></tr>
    </table>
</td></tr>
<tr><td height="30" colspan="2" style="text-align: center;"><?php echo JText::_("COM_JVLE_A21"); ?></td></tr>
<tr><td colspan="2"><strong><?php echo JText::_("COM_JVLE_A90"); ?></strong></td></tr>
<tr><td colspan="2">
    <table cellpadding="2" cellspacing="0" width="80%" align="center" style="border:1px solid #e1e2e3;">
    <tr><td colspan="2" class="jvle_code"><?php echo htmlentities($info, ENT_COMPAT, "UTF-8"); ?></td></tr>
    </table>
</td></tr>
<tr><td colspan="2">&nbsp;</td></tr>
<tr><td colspan="2" style="text-align: center;"><strong><?php echo JText::_("COM_JVLE_A91").'<br />'.JText::_("COM_JVLE_A18"); ?></strong></td></tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JvleUtil::showRequired(); ?><?php echo JText::_("COM_JVLE_A14"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="<?php echo $session->get('purl', '', 'aform'); ?>" name="purl" maxlength="200" size="40" /><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A9")); ?></td>  <?php /* DG:5 */ ?>  
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JvleUtil::showRequired(); ?><?php echo JText::_("COM_JVLE_A17"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="<?php echo $session->get('pemail', '', 'aform'); ?>" name="pemail" maxlength="100" size="40" /><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A6")); ?></td>   <?php /* DG:5 */ ?> 
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JvleUtil::showRequired(); ?><?php echo JText::_("COM_JVLE_A16"); ?></td>
    <td height="25" width="70%" valign="top"><input type="text" value="<?php echo $session->get('prurl', '', 'aform'); ?>" name="prurl" maxlength="200" size="40" /><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A7")); ?></td>  <?php /* DG:5 */ ?>  
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JvleUtil::showRequired(); ?><?php echo JText::_("COM_JVLE_A92"); ?></td>
    <td height="25" width="70%" valign="top"><input type="file" value="" name="pbanner" size="40" /><?php echo JvleUtil::showTipInfo(str_replace("{EXTNS}", $this->cfg->banner_extns, str_replace("{HEIGHT}", $this->cfg->banner_height_max, str_replace("{WIDTH}", $this->cfg->banner_width_max, str_replace("{SIZE}", $this->cfg->banner_kbsize_max, JText::_("COM_JVLE_A93")))))); ?></td>    
</tr>
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right"><?php echo JvleUtil::showRequired(); ?><?php echo JText::_("COM_JVLE_A12"); ?></td>
    <td height="25" width="70%" valign="top">
    <select name="pcat">
        <?php 
        for ($i=0;$i<count($obj->c_id);$i++)  
        {
            $selected = ($obj->c_id[$i] == $session->get('pcat', 0, 'aform')) ? "selected=selected" : "";   /* DG:5 */
            $levext = ($obj->c_cpid[$i]) ? '........' : '';    
            $disabled = ($obj->c_alink[$i]) ? '' : 'disabled="disabled"';    
        ?>
        <option <?php echo $disabled; ?> value="<?php echo $obj->c_id[$i]; ?>" <?php echo $selected; ?>><?php echo $levext.' '.stripslashes(JvleUtil::getCategoryName($obj->c_id[$i])); ?></option> <?php /* DG:5 */ ?>
        <?php    
        }
        ?>
    </select><?php echo JvleUtil::showTipInfo(JText::_("COM_JVLE_A11")); ?>
    </td>    
</tr>
<?php echo JvleSiteUtil::showCaptchaForm(JText::_("COM_JVLE_A41")); ?>   
<tr>
    <td height="25" width="30%" valign="top" style="text-align: right">&nbsp;</td>
    <td height="25" width="70%" valign="top"><input type="submit" name="submit1" value="<?php echo JText::_("COM_JVLE_A40"); ?>" /></td>    
</tr>    
</table>
<input type="hidden" name="option" value="com_jvle" />
<input type="hidden" name="task" value="addbanner" />
<input type="hidden" name="mode" value="1" />
</form>
<?php        
    }    
    
    function displayEmailActionResult($obj)
    {
        if (!$this->cfg->email_approval) return '';        
?>        
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A5"); ?></h1>
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<tr><td>&nbsp;</td></tr>
<tr><td><?php echo $obj->dispmsg; ?></td></tr>
<tr><td>&nbsp;</td></tr>
</table>
<?php        
    }

    function displayMessageOutput($obj)
    {                                           
        $color = ($obj->error) ? 'red' : 'blue';
        $nextpage = ((isset($obj->npage)) && ($obj->npage != '')) ? $obj->npage : JRoute::_('index.php?option=com_jvle&Itemid='._JVLE_ITEMID);
?>
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A4"); ?></h1>
<table width="100%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<tr><td colspan="2" height="20">&nbsp;</td></tr>
<tr>
    <td>
        <p style="text-align:center;"><strong><font color="<?php echo $color; ?>"><?php echo htmlspecialchars($obj->dispmsg); ?></font></strong></p> 
    </td>
</tr>
<tr><td colspan="2" height="20">&nbsp;</td></tr>
<tr><td colspan="2" height="20" style="text-align: center;"><a href="<?php echo $nextpage; ?>" alt="<?php echo JText::_("COM_JVLE_A3"); ?>"><?php echo JText::_("COM_JVLE_A3"); ?></a></td></tr>
</table>
<?php        
    }               
    
    function drawFeaturedLinksForm()
    {
        $item_name = 'Featured Link in '.$this->cfg->self_url;
        $url = "https://www.paypal.com/cgi-bin/webscr?cmd=_xclick-subscriptions&business=".urlencode($this->cfg->flinks_subemail)."&lc=US&item_name=".urlencode($item_name)."&no_note=1&no_shipping=1&a3=".urlencode($this->cfg->flinks_subamount)."&currency_code=USD&src=1&p3=1&t3=M&sra=1&bn=PP%2dSubscriptionsBF%3abtn_subscribeCC_LG%2egif%3aNonHosted";
?>
<h1 class="jvle_h1"><?php echo JText::_("COM_JVLE_A2"); ?></h1>
<table width="85%" cellspacing="0" cellpadding="4" align="center" class="jvle_mainborder">
<tr><td><?php echo str_replace("{FLINK-FEE}", $this->cfg->flinks_subamount, JText::_("COM_JVLE_A127")); ?></td></tr> 
<tr><td>
    <ul>
        <li><?php echo JText::_("COM_JVLE_A128"); ?></li>
        <li><?php echo JText::_("COM_JVLE_A129"); ?></li>
        <li><?php echo str_replace("{EMAIL}", $this->cfg->self_email, JText::_("COM_JVLE_A130")); ?></li>
    </ul>
</td></tr>
<tr><td><?php echo str_replace("{FLINK-FEE}", $this->cfg->flinks_subamount, JText::_("COM_JVLE_A131")); ?></td></tr> 
<tr><td>&nbsp;</td></tr> 
<tr><td style="text-align: center"><a href="<?php echo $url; ?>" title="<?php echo JText::_("COM_JVLE_A132"); ?>"><img alt="<?php echo JText::_("COM_JVLE_A132"); ?>" src="<?php echo $this->getImagePath(); ?>subscribe.gif" border="0" /></a></td></tr> 
</table>
<?php        
    }                       
}