<?php 
/****************************************************************************************** 
* $Id: router.php 98 2011-06-02 15:52:59Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL   
******************************************************************************************/ 
defined('_JEXEC') or die('Restricted access');
define("_JVLE_SEF_ALL_LOWERCASE", 1);

function jvleGetVal(&$query, $var) { 
    if (isset($query[$var])) 
    { 
        $val = $query[$var]; 
        unset($query[$var]); 
        return $val; 
    } 
     
    return ''; 
}

function jvlePutVal($segments, $mypos) {
    $varval = '';        
    if (isset($segments[$mypos]) && $segments[$mypos] != '') 
        $varval = str_replace(':','-',$segments[$mypos]);
        
    return $varval;    
} 

function getSubStringTill($string, $tillchar) {
    $myarr = explode($tillchar, $string);
    return $myarr[count($myarr)-1];        
}

function jvleFormQuery(&$query, $var, $val) {
    $query[$var] = $val;
}

function jvleBuildRoute(&$query) { 
    $segments = array(); 
    $database =& JFactory::getDBO(); 
        
    $controller = jvleGetVal($query, 'controller'); 
    $task = jvleGetVal($query, 'task'); 
    $view = jvleGetVal($query, 'view');
    
    switch ($task) {
        case 'emappr': {
            $segments[] = 'email-action';
            $segments[] = (jvleGetVal($query, 'act')) ? 'approve' : 'reject';
            break;            
        }
        case 'recommend': {
            $segments[] = 'recommend-website';
            break;
        }
        case 'checklinkstatus': {
            $segments[] = 'check-link-status';
            break;
        }        
        case 'redirect': {
        	$segments[] = 'visit';
        	$segments[] = jvleGetVal($query, 'id');        	
        	break;
        }
        case 'rate': {
            jvleGetVal($query, 'format');
            $segments[] = 'rate-website';
            $segments[] = jvleGetVal($query, 'lid');
            break;            
        }
        case 'addfeatured': {
            $segments[] = 'add-featured-website';
            break;            
        }       
        case 'addbanner': {
            $segments[] = 'add-website-banner';
            break;            
        }
        case 'addlink': {
            $segments[] = 'add-website-link';
            break;            
        }  
        case 'search': {
            $segments[] = 'search';
            break;                        
        }
        case 'all_category_links': {
            $cid = jvleGetVal($query, 'cid');
            $database->setQuery("select id, name from #__jvle_categories where id = '".(int)$cid."'");
            $row = $database->loadObject();
            $cname = JString::trim(stripslashes($row->name));
            
            $segments[] = str_replace(" ", "-", $cname)."-".(int)$cid; /* DG:8,CS:10 */         
            $segments[] = "index";
            break;            
        }                        
        case 'links': {
            $cid = jvleGetVal($query, 'cid');
            $database->setQuery("select id, name from #__jvle_categories where id = '".(int)$cid."'");
            $row = $database->loadObject();
            $cname = JString::trim(stripslashes($row->name));
            
            $database->setQuery("select id, fe_num_links from #__jvle_settings");
            $row = $database->loadObject();
            $links_per_page = $row->fe_num_links;

            $limitstart = jvleGetVal($query, 'start');
            if ($limitstart == '')
                $limitstart = 0;
            
            $pagenum = ($limitstart/$links_per_page) + 1;
                        
            $segments[] = str_replace(" ", "-", $cname)."-".(int)$cid; /* DG:8,CS:10 */            
            $segments[] = "page".$pagenum;
            break;            
        }
        default: {
            $segments[] = "index";
        }
    }
    
    if (_JVLE_SEF_ALL_LOWERCASE) {
        for ($i=0;$i<count($segments);$i++)
            $segments[$i] = JString::strtolower($segments[$i]);
    }
    
    return $segments;
}

function jvleParseRoute($segments) { 
    $database =& JFactory::getDBO(); 
    $query = array(); 
     
    $arg_0 = jvlePutVal($segments, 0); 
    $arg_1 = jvlePutVal($segments, 1); 
    $arg_2 = jvlePutVal($segments, 2);
    
    if ($arg_0 == "index") {        
    }
    else if ($arg_0 == 'email-action') { 
        jvleFormQuery($query, 'task', 'emappr');                  
        jvleFormQuery($query, 'act', ($arg_1 == "approve") ? 1 : 0); 
    }    
    else if ($arg_0 == 'recommend-website') { 
        jvleFormQuery($query, 'task', 'recommend'); 
    }    
    else if ($arg_0 == 'check-link-status') { 
        jvleFormQuery($query, 'task', 'checklinkstatus'); 
    }    
    else if ($arg_0 == 'rate-website') { 
        jvleFormQuery($query, 'task', 'rate'); 
        jvleFormQuery($query, 'format', 'raw');
        jvleFormQuery($query, 'lid', (int)$arg_1);
    }
    else if ($arg_0 == 'visit') { 
        jvleFormQuery($query, 'task', 'redirect'); 
        jvleFormQuery($query, 'id', (int)$arg_1);
    }
    else if ($arg_0 == 'add-featured-website') { 
        jvleFormQuery($query, 'task', 'addfeatured'); 
    }     
    else if ($arg_0 == 'add-website-link') { 
        jvleFormQuery($query, 'task', 'addlink'); 
    } 
    else if ($arg_0 == 'add-website-banner') { 
        jvleFormQuery($query, 'task', 'addbanner'); 
    }  
    else if ($arg_0 == 'search') { 
        jvleFormQuery($query, 'task', 'search'); 
    }           
    else {
        if ($arg_1 == "index") {
            $cid = getSubStringTill($arg_0, '-'); /* CS:10 */                        
            jvleFormQuery($query, 'task', 'all_category_links'); 
            jvleFormQuery($query, 'cid', $cid);
        }
        else if (JString::substr($arg_1, 0, 4) == "page") {
            $cid = getSubStringTill($arg_0, '-'); /* CS:10 */
                        
            $database->setQuery("select id, fe_num_links from #__jvle_settings");
            $row = $database->loadObject();
            $links_per_page = $row->fe_num_links;            
            
            $pagenum = intval(JString::substr($arg_1, 4));
            $limitstart = ($pagenum-1) * $links_per_page;
            
            jvleFormQuery($query, 'task', 'links'); 
            jvleFormQuery($query, 'cid', $cid);            
            jvleFormQuery($query, 'limitstart', $limitstart);
        }
    }
    
    return $query; 
}