<?php
/******************************************************************************************
* $Id: controller.php 79 2011-04-02 16:01:50Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
jimport("joomla.application.component.controller");
//***************************************************************************************************
class JvleController extends JController
{
    function display()
    {
        parent::display();
    }

    function search()
    {
        $cfg = JvleCfg::getInstance();
        if (!$cfg->enable_search)
            return;
        
        $mode = JRequest::getInt('mode', 0);
        if ($mode) {                    	
            $query = JRequest::getString('query', '');
            $url = JRoute::_('index.php?option=com_jvle&Itemid='._JVLE_ITEMID.'&task=search&query='.htmlspecialchars($query));
            header("Location: ".$url);
        } else {
            JRequest::setVar('view', 'search');
            parent::display();            
        }
    }
    
    function links()
    {
        $cid = JRequest::getInt('cid', 0);
        if (!$cid)    
            return;
            
        JRequest::setVar('layout', 'links');
        parent::display();
    }
    
    function all_category_links()
    {
        $cid = JRequest::getInt('cid', 0);
        if (!$cid)    
            return;
            
        JRequest::setVar('layout', 'all_links');
        parent::display();
    }
    
    function addlink()
    {
        JRequest::setVar('layout', 'addlink');
        parent::display();            
    }
    
    function addbanner()
    {
        JRequest::setVar('layout', 'addbanner');
        parent::display();            
    }

    function addfeatured()
    {
        JRequest::setVar('layout', 'addfeatured');
        parent::display();
    } 
    
    function rate()
    {
        $cfg = JvleCfg::getInstance();    
        $user =& JFactory::getUser();
        
        if (($cfg->link_rating_by == "all") || (($cfg->link_rating_by == "registered") && ($user->get('id'))))
        {
            $lid = JRequest::getInt('lid', -1);
            $rating = JRequest::getInt('rating', 0);
            
            if (!$rating)
                echo JText::_("COM_JVLE_A79");
            else
            {
                $model =& $this->getModel('Jvle');
                $ret = $model->rateLink();
                switch ($ret)
                {
                    case 1: echo JText::_("COM_JVLE_A80").""; break;
                    case 0: echo JText::_("COM_JVLE_A81").""; break;
                    default: break;
                }
            }
        }
    }
    
    function redirect()
    {
    	$id = JRequest::getInt('id', 0);
    	if (!$id)
    		return;
    	
    	$row = JvleDb::getRow("select link_type, partner_url, hits from #__jvle_links where id = '".(int)$id."'");
    	if ((!$row) || ($row->link_type != "ONE-WAY"))
    		return;
    	
    	$hits = $row->hits + 1; 
    	JvleDb::update("update #__jvle_links set hits = '".(int)$hits."' where id = '".(int)$id."'");
    	
    	header("Location: ".$row->partner_url);
    }
    
    function checklinkstatus()
    {
        $cfg = JvleCfg::getInstance();
        if (!$cfg->enable_checklinkstatus)
            return;
            
        JRequest::setVar('view', 'checklinkstatus');
        parent::display();        
    }   
    
    function recommend()
    {
        $cfg = JvleCfg::getInstance();
        if (!$cfg->enable_recweb)
            return;
                    
        JRequest::setVar('view', 'recommend');
        parent::display();        
    }
    
    function emappr()
    {
        $cfg = JvleCfg::getInstance();
        if (!$cfg->email_approval)
            return;
                    
        JRequest::setVar('layout', 'emailappr');
        parent::display();      
    } 
    
    function cron()
    {
        $model =& $this->getModel('Jvle');
        $model->runCronJob();
        exit(0);        
    }     
}