<?php
// *************************************************************************
// *                                                                       *
// * Product: VirtueMart RBS WorldPay Business Gateway                     *
// * Filename: worldpayadv_notify.php                                      *
// * Release Date: 2011.04.18                                              *
// * Build Time: 18 April 2011 21:37                                       *
// * Code Word: Srednekolymsk                                              *
// * Version: 1.5.34                                                       *
// * For: Joomla 1.5/VirtueMart 1.1.x                                      *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * Author: E-commerce Solution                                           *
// * Email: support@virtuemart-solutions.com                               *
// * Website: http://www.virtuemart-solutions.com                          *
// * Copyright: (C) 2008-2010 All rights reserved.                         *
// * Licence: Commercial                                                   *
// *                                                                       *
// *************************************************************************
// *                                                                       *
// * This software is furnished under a license and may be used and copied *
// * only  in  accordance  with  the  terms  of such  license and with the *
// * inclusion of the above copyright notice.  This software  or any other *
// * copies thereof may not be provided or otherwise made available to any *
// * other person.  No title to and  ownership of the  software is  hereby *
// * transferred.                                                          *
// *                                                                       *
// * You may not reverse  engineer, decompile, defeat  license  encryption *
// * mechanisms, or  disassemble this software product or software product *
// * license.  Ecom Solution  may  terminate  this license  if you fail to *
// * comply with any of the terms and conditions set forth in our end user *
// * license agreement (EULA).  In such event,  licensee  agrees to return *
// * licensor  or destroy  all copies of software  upon termination of the *
// * license.                                                              *
// *                                                                       *
// *************************************************************************


// access licence protected functions
require_once('licencecheck.e.php'); 
require_once('standalone.e.php'); 
require_once('generic_fns.php'); 

// include config 
require_once( CLASSPATH. 'payment/ps_worldpayadv.cfg.php' );

// include payment method 
global $payment_method;
require_once( CLASSPATH. 'payment/ps_worldpayadv.php' );
$payment_method = new ps_worldpayadv();  

$your_ip = $_SERVER['REMOTE_ADDR']; 
$hostname = gethostbyaddr($your_ip);

standalone_start($payment_method, '');
echo "<p><b>This is the hidden WorldPay callback script, which is not intended to be viewed by the shopper. </b><p>";

//error_reporting(E_ALL);

// check ip
$AllowedIPs=split(',',  WPADV_ALLOWEDIP);
if (CheckAccess($AllowedIPs) == 0) {
  echo " <b>Access Unauthorised:</b> " . $hostname;
  exit; 
} else { 
  echo " <b>Access Authorised:</b> " . $hostname;
}
echo "<p>";

if (!$_POST) die('No POST data received');

$payment_status  = trim(stripslashes(post('transStatus'))); 
$order_id =  trim(stripslashes(post('cartId')));
$instId =  trim(stripslashes(post('instId')));
$callbackPW =  trim(stripslashes(post('callbackPW')));
$transId =  trim(stripslashes(post('transId')));

// check the order  
if ( trim($order_id) == '')
  exit('Error: No cartId specified');     

// check the order in db
$q = "SELECT order_id, order_total FROM #__{vm}_orders "; 
$q .= " WHERE order_id='" . $order_id. "'";     
$db = new ps_DB;
$db->query($q);
if( $db->next_record() ) {	
  // order exists
  // check inst id 
  if( $instId != WPADV_INST_ID )
	  exit('Error: Wrong instId received: ' . $instId);   
	
  // check callback password
  if( $callbackPW != WPADV_CALLBACKPW )
	  exit('Error: Wrong CallbackPW received: ' . $callbackPW);   

  $d['order_id'] = $order_id;    //this identifies the order record
  $d['order_comment'] = 'WorldPay Notification';  
  $d['notify_customer'] = WPADV_NOTIFYCUST; 
  if( $payment_status == 'Y' ){
	  $d['order_status'] = 'C';   // C for confirmed
  }
  else if( $payment_status == 'C' ){
	  $d['order_status'] = WPADV_ORDER_STATUS_CANCELLED;  // X for cancelled
  }

  // update order
  update_order($d);  
  echo "Success: Order updated: " . $order_id . "<br>";
  
  // update order_payment_log      
  $q = "UPDATE #__{vm}_order_payment SET ";
  $q .= "\n order_payment_log='Transaction Id: " . $transId . "',  "; 
  $q .= "\n order_payment_trans_id='" . $transId . "'  "; 
  $q .= "\n WHERE order_id='".$order_id."'";
  $db->query($q);  
                    
  echo "Order payment log updated<p>";
      
  // success code 
  // do_success_scripts();
  
} else {
	echo "Error: Order not found: " . $order_id;
}


?>
</body></html>