<?php
/**
 * @package      JoomlaMind Components
 * @subpackage   Vip Quotes
 * @copyright    Copyright (C) 2008 JoomlaMind.com. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

defined('_JEXEC') or die('Restricted access');
class TableQuotes extends JTable {
    
    public $id          = null;
    public $quote       = null;
    public $author      = null;
    public $category_id = null;
    public $user_id     = null;
    public $published   = null;
    public $liked       = null;
    public $date        = null;

    public function __construct(&$db) {
        
        parent::__construct( '#__vq_quotes', 'id', $db );
        
    }
    
    /**
     * Loads a row from the database and binds the fields to the object properties
     *
     * @access  public
     * @param   mixed   Optional primary key.  If not specifed, the value of current key is used
     * @return  boolean True if successful
     */
    public function load( $oid=null )
    {
        $k = $this->_tbl_key;

        if ($oid !== null) {
            $this->$k = $oid;
        }

        $oid = $this->$k;

        if ($oid === null) {
            return false;
        }
        $this->reset();

        $db =& $this->getDBO();

        $query = 'SELECT *'
        . ' FROM '.$this->_tbl
        . ' WHERE '.$this->_tbl_key.' = '.$db->Quote($oid);
        
        if ( !is_null( $this->user_id ) ) {
        	$query .=  " AND user_id=" . $db->Quote($this->user_id);
        }
        
        if ( !is_null( $this->published ) ) {
            $query .=  " AND published=" . $db->Quote($this->published);
        }
        
        $db->setQuery( $query );

        if ($result = $db->loadAssoc( )) {
            return $this->bind($result);
        }
        else
        {
            $this->setError( $db->getErrorMsg() );
            return false;
        }
    }
    
}
?>