<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class VqHelper {
	
	// Check the table in so it can be edited.... we are done with it anyway
    public static $componentLink = 'index.php?option=com_vipquotes';
    
	public static function setNextPage( $view, $layout = "" ) {
		 
		if ( !$view ) {
			JError::raiseError(404,JText::_("This view does not exist."));
		}
		
		$app = JFactory::getApplication();
        $app->setUserState("redirect.view", $view );
        $app->setUserState("redirect.layout", $layout );
        
	}
	
    /**
     * Redirect to view and layout
     *
     */
    public static function getNextPage( $view = null ) {
        
        // Set new view and layout
        $app          =   JFactory::getApplication();
        $newViewName  =  $app->getUserState("redirect.view");
        $layoutName   =  $app->getUserState("redirect.layout");
        
        // Set new view
        if ( !is_null( $view )  ) {
            $newViewName   =   $view;
        }
        
        //Build back link
        if ( $newViewName ) {
            
            self::$componentLink  .=  "&view=" . $newViewName;
            
            if ( $layoutName ) {
                self::$componentLink   .=  "&layout=" . $layoutName;
            }
            
        }
        
        return JRoute::_( self::$componentLink, false );
        
    }
    
}
?>