<?php
/**
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 * @author       Todor Iliev
 * @copyright    Copyright (C) 2010 Todor Iliev <todor.iliev@itprism.co.uk>. All rights reserved.
 * @license      http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * Vip Quotes is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.controller' );

/**
 * Vip Quotes Controller
 *
 * @package      ITPrism Components
 * @subpackage   Vip Quotes
 */
class VipQuotesController extends JController {
    
	public function __construct($config = array())	{
		parent::__construct($config);

//		 Register Extra tasks
		$this->registerTask( 'add'  ,   'display' );
		$this->registerTask( 'edit' ,   'display' );
		$this->registerTask( 'apply',   'save'    );
		
		if ( !JFactory::getUser()->id ) {
			JError::raiseError(500,JText::_("You are not authorized."));
		}
		
	}

	public function display( ) {

		$document =& JFactory::getDocument();
        /* @var $document JDocument */
		
		$document->addStyleSheet(JURI::root() . "components/com_vipquotes/vip_quotes.css");
		
        $viewType = $document->getType();
        
        // Set add and edit task parameters
        switch($this->getTask())
		{
			case 'add'     :
			{
				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar( 'layout', 'form'  );

			} 
			break;
			case 'edit'    :
			{
				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar( 'layout', 'form'  );

			} 
			break;
			
		}
        
		// Get layout value
        $viewLayout =   JRequest::getVar('layout', 'default');
        // Get view value
        $viewName   =   JRequest::getVar('view', 'quotes');
        
        // Get view
        $view       =   $this->getView( $viewName, $viewType, "View" );
        
        // Get model
        $model      =   $this->getModel( $viewName , "Model");
        if (!JError::isError( $model ) ) { // Set model to view
            $view->setModel( $model, true );
        }
        
        // Set layout into view 
        $view->setLayout($viewLayout);
        
        // Display view
        $view->display();
	}

	/**
	 * Save item
	 *
	 */
	public function save() {
	    
	    // Get view name
	    $viewName  =   JRequest::getVar('view', '');
	    
	    if ( !$viewName ) {
            JError::raiseError(500,JText::_("This view does not exist."));
        }
        
	    // Check token
        if(!JRequest::getVar(JUtility::getToken(), false, 'POST'))  {
            JError::raiseError('403', JText::_('Request Forbidden'));
        }
        
		$model =& $this->getModel($viewName, "Model");
		
		$model->store();

        // Redirecting
        $this->setRedirect( VqHelper::getNextPage() );
        
	}

	/**
	 * Remove items
	 *
	 */
	public function remove() {
	    
	    // Check token
        if(!JRequest::getVar(JUtility::getToken(), false, 'POST'))  {
            JError::raiseError('403', JText::_('Request Forbidden'));
        }
        
	    $cids = JRequest::getVar( 'cid', array(), 'POST', 'array' );
        JArrayHelper::toInteger($cid);

        if (count( $cids ) < 1) {
            JError::raiseError(500, JText::_( 'Select an quote to delete.' ) );
        }
        
	    // Get view name
	    $viewName  =   JRequest::getVar('view', '');
	    if ( !$viewName ) {
            JError::raiseError(500,JText::_("This view does not exist."));
        }
        
	    // Get model
	    $model =& $this->getModel($viewName, 'Model');
	    $model->delete( $cids );

	    // Redirecting
        $this->setRedirect( VqHelper::getNextPage() );
	    
	}

	/**
     * Publish items
     *
     */
	public function publish() {
	    
        // Check token
        if(!JRequest::getVar(JUtility::getToken(), false, 'POST'))  {
            JError::raiseError('403', JText::_('Request Forbidden'));
        }
        
		$cids = JRequest::getVar( 'cid' );
		JArrayHelper::toInteger($cids);

		if (count( $cids ) < 1) {
			JError::raiseError(500, JText::_( 'Select an quote to publish.' ) );
		}

	    // Get view name
	    $viewName  =   JRequest::getVar('view', '');
	    
	    if ( !$viewName ) {
            JError::raiseError(500,JText::_("This view does not exist."));
        }
        
	    // Get model
	    $model =& $this->getModel( $viewName, 'Model');
	    
	    $model->publish($cids, 1);
	    
		// Redirecting
        $this->setRedirect( VqHelper::getNextPage() );
	}

    /**
     * Unpublish items
     *
     */
	public function unpublish() {
	    
	    // Check token
        if(!JRequest::getVar(JUtility::getToken(), false, 'POST'))  {
            JError::raiseError('403', JText::_('Request Forbidden'));
        }
        
		$cids = JRequest::getVar( 'cid', array());
        JArrayHelper::toInteger($cids);

        if (count( $cids ) < 1) {
            JError::raiseError(500, JText::_( 'Select an quote to unpublish.' ) );
        }

        // Get view name
        $viewName  =   JRequest::getVar('view', '');
        
        if ( !$viewName ) {
            JError::raiseError(500,JText::_("This view does not exist."));
        }
        
        // Get model
        $model =& $this->getModel( $viewName, 'Model');
        
        $model->publish($cids, 0);
        
        // Redirecting
        $this->setRedirect( VqHelper::getNextPage() );
	}

	/**
	 * Cancle operation
	 *
	 */
	public function cancel() {
	    
		// Redirecting
        $this->setRedirect( VqHelper::$componentLink );
	}

	/**
	 * Import items
	 *
	 */
	public function import() {
	    
	    // Check token
        if(!JRequest::getVar(JUtility::getToken(), false, 'POST'))  {
            JError::raiseError('403', JText::_('Request Forbidden'));
        }
        
		// Get view
	    $viewName   =   JRequest::getVar('view', '');
	    
	    // Get model
	    $model =& $this->getModel($viewName, 'Model');
	    
		$model->import();

        // Redirecting
        $this->setRedirect( VqHelper::$componentLink );
		
	}
	
    /**
     * Recover items
     *
     */
    public function recover() {
        
        // Check token
        if(!JRequest::getVar(JUtility::getToken(), false, 'POST'))  {
            JError::raiseError('403', JText::_('Request Forbidden'));
        }
        
        $cids = JRequest::getVar( 'cid', array());
        JArrayHelper::toInteger($cids);

        if (count( $cids ) < 1) {
            JError::raiseError(500, JText::_( 'Select an quote to recover.' ) );
        }

        // Get view name
        $viewName  =   JRequest::getVar('view', '');
        
        if ( !$viewName ) {
            JError::raiseError(500,JText::_("This view does not exist."));
        }
        
        // Get model
        $model =& $this->getModel( $viewName, 'Model');
        
        $model->recover($cids);
        
        // Redirecting
        $this->setRedirect( VqHelper::getNextPage() );
    }
	
	/**
	 * Archive items
	 *
	 */
	public function archive() {
	    
	    // Get view
	    $viewName   =   JRequest::getVar('view', '');
	    
	    // Get model
	    $model =& $this->getModel($viewName, 'Model');
	    
	    $file      =   $model->archive();
	    $fileName  =   basename($file);
	    
	    // Build the appropriate paths
		$config   =&  JFactory::getConfig();
        $tmpDir   =   $config->getValue('config.tmp_path');
        
        $oldDir   =   getcwd();
        chdir($tmpDir);
        
        jimport('joomla.filesystem.archive');
		$archive = JArchive::create($fileName, array( $fileName ), 'gz','', '', true, false );
		
		chdir($oldDir);
		
		// redirect to file
        $this->setRedirect('/tmp/'.$fileName.'.gz');
		
	}
	
}
?>