<?php
/*
 * --------------------------------------------------------------------------------
   Weblogicx India  - K2 Store v 2.0
 * --------------------------------------------------------------------------------
 * @package		Joomla! 1.5x
 * @subpackage	K2 Store
 * @author    	Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link		http://weblogicxindia.com
 * --------------------------------------------------------------------------------
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');

class K2StoreViewOrder extends JView
{

	function display($tpl = null) {
		
		global $mainframe, $option;
		require_once(JPATH_SITE.DS.'components'.DS.'com_k2store'.DS.'helpers'.DS.'icon.php');
		$db		=& JFactory::getDBO();
		$uri	=& JFactory::getURI();
		$model		= &$this->getModel('order');
		$params = &JComponentHelper::getParams('com_k2store');
		// get order data
		$order	= & $this->get('Data');
		//get order details , items
		$items = $model->getOrderDetails($order->order_id);
	
		//parse the trasaction details
		$txns= new JParameter($order->transaction_details);
		
		//get address
		$address = $model->getShippingAddress($order->user_id);
		
		$this->assignRef('order',		$order);
		$this->assignRef('items',		$items);
		$this->assignRef('txns',	$txns);
		$this->assignRef('address',	$address);
		$this->assignRef('params',	$params);
	
		JToolBarHelper::title(JText::_('Detail Order'));
		JToolBarHelper::cancel( 'cancel', 'Close' );
		JSubMenuHelper::addEntry(JText::_('Dashboard'), 'index.php?option=com_k2store');
		JSubMenuHelper::addEntry(JText::_('Orders'), 'index.php?option=com_k2store&view=orders', true);
		JSubMenuHelper::addEntry(JText::_('Users'), 'index.php?option=com_k2store&view=addresses');
		JSubMenuHelper::addEntry(JText::_('Information'), 'index.php?option=com_k2store&view=info');		
		
		parent::display($tpl);
	}

}