<?php
/******************************************************************************************
* $Id: view.html.php 100 2011-06-03 07:13:39Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
// Prevent direct access  
defined('_JEXEC') or die('Restricted access'); 
//***************************************************************************************************
// Import the libraries
jimport("joomla.application.component.view");
//***************************************************************************************************
// Define the view class
class JvleViewDashboard extends JView
{
//***************************************************************************************************	 
	 function display($tpl = null)
	 {
	 	$layout_name = JRequest::getVar('layout');
	 	if ($layout_name == 'about')
            JToolBarHelper::title('About JV-LE', 'generic.png');
	 	else
	 	{
            $latversion = JvleUtil::getLatestVersion();
            $this->assignRef("latest_version", $latversion);
                    
            $installed_version = JvlePostinstall::getXmlVersion();
            $this->assignRef("installed_version", $installed_version);

            // Get live news feed for JV-LE
            $arrFeeds = array();
            if (class_exists("DOMDocument")) {
                $doc = new DOMDocument();
                $doc->load(JvleUtil::NEWS_FEED_URL);
                $cnt=0;
                foreach ($doc->getElementsByTagName('item') as $node) {
                    $itemRSS = array ( 
                        'title' => $node->getElementsByTagName('title')->item(0)->nodeValue,
                        'desc' => $node->getElementsByTagName('description')->item(0)->nodeValue,
                        'link' => $node->getElementsByTagName('link')->item(0)->nodeValue,
                        'date' => $node->getElementsByTagName('pubDate')->item(0)->nodeValue
                    );
                    array_push($arrFeeds, $itemRSS);    
                    $cnt++;
                    if ($cnt == 5)
                        break;
                } 
            }
            $this->assignRef("arrFeeds", $arrFeeds);
                        
            JToolBarHelper::title('JV-LE Dashboard', 'generic.png');
	 	}
	 	
         // Draw the layout
        $document =& JFactory::getDocument();
        $document->addStyleSheet(_MOS_LIVESITE."/administrator/components/com_jvle/assets/css/jvle.css");
        
        if (_JVLE_J16) {
            $canDo = JvleAdminUtil::getActions();
            if ($canDo->get('core.admin'))
                JToolBarHelper::preferences('com_jvle');
        }
 
		parent::display($tpl);		
	 }
//***************************************************************************************************	 
}