<?php
/******************************************************************************************
* $Id: default.php 109 2011-07-07 11:05:54Z sniranjan $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
?>
<?php defined('_JEXEC') or die('Restricted access'); ?>

<form action="index.php" method="post" name="adminForm" id="adminForm">
<?php 
    $pane =& JPane::getInstance('Tabs');
    echo $pane->startPane('configPane'); 
    echo $pane->startPanel('Self Config','self-page');
?>    
<table class="adminform">
    <tr>
        <td valign="top" width="40%"><?php echo JvleUtil::showRequired(); ?>Your Website Title</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="self_title" value="<?php echo stripslashes($this->cfg->self_title); ?>" /><?php echo JvleUtil::showTipInfo('Title or anchor text, that you want other webmasters to use in your link on their sites (80 char max)'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%"><?php echo JvleUtil::showRequired(); ?>Your Website URL</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="self_url" value="<?php echo stripslashes($this->cfg->self_url); ?>" /><?php echo JvleUtil::showTipInfo('Your home page url where other webmasters should link. Start with http://. Do NOT end with / (slash) (80 char max)'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%"><?php echo JvleUtil::showRequired(); ?>Your Website Description</td>
        <td valign="top" width="60%"><textarea class="inputbox" rows="12" cols="60" name="self_desc"><?php echo stripslashes($this->cfg->self_desc); ?></textarea><?php echo JvleUtil::showTipInfo('Description for your link (250 char max)'); ?></td>
    </tr> 
    <tr>
        <td valign="top" width="40%"><?php echo JvleUtil::showRequired(); ?>Your Email</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="self_email" value="<?php echo stripslashes($this->cfg->self_email); ?>" /><?php echo JvleUtil::showTipInfo('Your email address to use in notes to other webmasters'); ?></td>
    </tr>       
</table>
<?php
    echo $pane->endPanel(); 
    echo $pane->startPanel('Layout Options',"layout-page");
?>     
<table class="adminform">
    <tr>
        <td valign="top" width="40%">Directory Title</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="fe_title" value="<?php echo stripslashes($this->cfg->fe_title); ?>" /><?php echo JvleUtil::showTipInfo('Title to appear above the category listing in Frontend menu component page'); ?></td>
    </tr>               
    <tr>
        <td valign="top" width="40%">Directory Slogan</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="header_slogan" value="<?php echo stripslashes($this->cfg->header_slogan); ?>" /><?php echo JvleUtil::showTipInfo('This slogan will be displayed just below the directory title in frontend directory'); ?></td>
    </tr>               
    <tr>
        <td valign="top" width="40%">Directory Summary</td>
        <td valign="top" width="60%"><textarea class="inputbox" rows="12" cols="60" name="fe_dir_summary"><?php echo stripslashes($this->cfg->fe_dir_summary); ?></textarea><?php echo JvleUtil::showTipInfo('Optional, Summary text to appear above the directory listing only in the home page. Can be used to welcome users to the directory or introduce the directory or put down some rules or any other purpose. HTML is allowed'); ?></td>
    </tr>   
    <tr>
        <td valign="top" width="40%">Add Link Summary</td>
        <td valign="top" width="60%"><textarea class="inputbox" rows="12" cols="60" name="fe_newlink_summary"><?php echo stripslashes($this->cfg->fe_newlink_summary); ?></textarea><?php echo JvleUtil::showTipInfo('Optional, Summary text to appear above the Add New Link form. Can be used for displaying specific new link submit instructions or for similar purposes. HTML is allowed'); ?></td>
    </tr>                  
    <tr>
        <td valign="top" width="40%">Instructions/Specific Data</td>
        <td valign="top" width="60%"><textarea class="inputbox" rows="12" cols="60" name="fe_instructions"><?php echo stripslashes($this->cfg->fe_instructions); ?></textarea><?php echo JvleUtil::showTipInfo('Optional, This data will be visible beneath the directory listing in Frontend menu component home page. HTML is allowed'); ?></td>
    </tr>              
    <tr>
        <td valign="top" width="40%">Number of links to display per page?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("fe_num_links", $this->cfg->fe_num_links, array('5','10','25','50'), array('5','10','25','50')); ?><?php echo JvleUtil::showTipInfo('Number of links per page beyond which pagination would be done'); ?></td>
    </tr>                       
    <tr>
        <td valign="top" width="40%">Should links to partners be opened in new window?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("window_new", $this->cfg->window_new, array('Yes', 'No'), array(1,0)); ?><?php echo JvleUtil::showTipInfo('Yes implies the partner website link will be displayed in a new window. No implies it will be displayed in existing window'); ?></td>
    </tr>     
    <tr>
        <td valign="top" width="40%">Display Latest Links in Frontend?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("show_latest_links", $this->cfg->show_latest_links, array('Yes - In All Pages', 'Yes - Only in Directory Home Page', 'No'), array(2,1,0)); ?><?php echo JvleUtil::showTipInfo('If yes, it displays the last 5 links added'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Enable SNAP preview of links in directory?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("enable_snap", $this->cfg->enable_snap, array('Yes', 'No'), array(1,0)); ?><?php echo JvleUtil::showTipInfo('Yes implies that, preview of links would be shown in a SNAP window when visitors hover on them. This is further configurable at category and individual link level also. For information on SNAP, please visit http://www.snap.com'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Enable users to use Add Link Form to submit link requests from frontend?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("fe_addlink", $this->cfg->fe_addlink, array('Yes', 'No'), array(1,0)); ?><?php echo JvleUtil::showTipInfo('Enabling this option would let users submit link exchange requests at frontend'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Enable visitors to search the link directory?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("enable_search", $this->cfg->enable_search, array('Yes', 'No'), array(1,0)); ?><?php echo JvleUtil::showTipInfo('Provides a search form for users to search the link directory in the frontend'); ?></td>
    </tr>                   
</table>
<?php
    echo $pane->endPanel(); 
    echo $pane->startPanel('Exchange Options',"xchange-page");
?>            
<table class="adminform">
    <tr>
        <td valign="top" width="40%">Enable Backlink Check during New Link Submit?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("enable_rlc_fe", $this->cfg->enable_rlc_fe, array('Yes', 'No'), array(1,0)); ?><?php echo JvleUtil::showTipInfo('Enabling this option would validate the backlink to your website, when a user adds his link using the Add New Link form in the frontend'); ?></td>
    </tr>     
    <tr>
        <td valign="top" width="40%">Auto Approve link request at frontend?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("auto_approve", $this->cfg->auto_approve, array('Yes', 'No'), array(1,0)); ?><?php echo JvleUtil::showTipInfo('Yes would mean, that any request submitted by anyone via the Add Link form at frontend will be approved automatically. If you sure of this doing this, we recommend you enable "Enable Backlink Check during New Link Submit?" using the previous option. Setting the value to No will enable the request to be submitted to you for approval/rejection'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Enable Email Approval?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("email_approval", $this->cfg->email_approval, array('Yes', 'No'), array(1,0)); ?><?php echo JvleUtil::showTipInfo('Yes implies that, when a user submits a link exchange request from frontend, the email that will be sent to you (administrator), will contain a URL which when clicked will approve the request immediately'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Enable Status Update during Reciprocal Check?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("rlc_status_update", $this->cfg->rlc_status_update, array('Yes', 'No'), array(1,0)); ?><?php echo JvleUtil::showTipInfo('You can manually run the reciprocal link checker to validate if the reciprocal links at your partner websites are intact and pointing back to you. Enabling this option will update the status of the link to one of the following values as a result of the reciprocal check. <br />a. ESTABLISHED => When reciprocal link exists at partner site in the specified reciprocal link<br />b. PENDING => When reciprocal link exchange is pending from your partner or if you do not know the reciprocal link yet or if the exchange is pending from your side<br />c. UNKNOWN => When the validation for reciprocal link could not be performed due to some reason'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Generic Reason for Rejection</td>
        <td valign="top" width="60%"><textarea class="inputbox" rows="12" cols="60" name="generic_reject_reason"><?php echo stripslashes($this->cfg->generic_reject_reason); ?></textarea><?php echo JvleUtil::showTipInfo('Optional - When you reject a link exchange request using Reject or by Email, the reason provided in this field will be sent to your partner. You may use this to add a generic reason for rejection'); ?></td>
    </tr>  
               
</table>
<?php
    echo $pane->endPanel(); 
    echo $pane->startPanel('Banner Exchange',"bannerxchange-page");
?>    
<table class="adminform">
    <tr>
        <td valign="top" width="40%">Enable Banner Exchange with this website?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("fe_addbanner", $this->cfg->fe_addbanner, array('Yes', 'No'), array(1,0)); ?><?php echo JvleUtil::showTipInfo('No implies that, users cannot exchange banners with this website'); ?></td>
    </tr>   
    <tr>
        <td valign="top" width="40%">Location of your website banner image</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="banner_loc" value="<?php echo stripslashes($this->cfg->banner_loc); ?>" /><?php echo JvleUtil::showTipInfo('Please upload your banner to a location on your server and provide the location here. Partners will use this banner to exchange banner links with you. Please start with http:// and make sure that the image filename is included in the location'); ?></td>
    </tr>   
    <tr>
        <td valign="top" width="40%">Add Banner Summary</td>
        <td valign="top" width="60%"><textarea class="inputbox" rows="12" cols="60" name="fe_newbanner_summary"><?php echo stripslashes($this->cfg->fe_newbanner_summary); ?></textarea><?php echo JvleUtil::showTipInfo('Optional, Summary text to appear above the Add New Banner form. Can be used for displaying specific new banner submit instructions or for similar purposes. HTML is allowed'); ?></td>
    </tr>  
    <tr>
        <td valign="top" width="40%">Maximum Size of Partner Banner in KB</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="banner_kbsize_max" value="<?php echo stripslashes($this->cfg->banner_kbsize_max); ?>" /><?php echo JvleUtil::showTipInfo('Error will be thown while adding banner if size of banner exceeds this value'); ?></td>
    </tr>   
    <tr>
        <td valign="top" width="40%">Maximum Allowed WIDTH dimension of Partner banner in pixels</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="banner_width_max" value="<?php echo stripslashes($this->cfg->banner_width_max); ?>" /><?php echo JvleUtil::showTipInfo('Error will be thown while adding banner if width of banner exceeds this value'); ?></td>
    </tr>   
    <tr>
        <td valign="top" width="40%">Maximum Allowed HEIGHT dimension of Partner banner in pixels</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="banner_height_max" value="<?php echo stripslashes($this->cfg->banner_height_max); ?>" /><?php echo JvleUtil::showTipInfo('Error will be thown while adding banner if height of banner exceeds this value'); ?></td>
    </tr>   
    <tr>
        <td valign="top" width="40%">Allowed Extensions for Partner banner</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="banner_extns" value="<?php echo stripslashes($this->cfg->banner_extns); ?>" /><?php echo JvleUtil::showTipInfo('Separate the extensions using comma. Error will be thown while adding banner if it does not match one of the extensions specified in this list'); ?></td>
    </tr>   
</table>
<?php
    echo $pane->endPanel(); 
    echo $pane->startPanel('Featured Links',"featuredlinx-page");
?>    
<table class="adminform">
    <tr>
        <td valign="top" width="40%">Enable featured links functionality?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("enable_flinks", $this->cfg->enable_flinks, array('Yes', 'No'), array(1,0)); ?><?php echo JvleUtil::showTipInfo('If enabled, users can add one way links to their website from your website by paying a subscription using Paypal. These links CAN be ONE-WAY links only'); ?></td>
    </tr> 
    <tr>
        <td valign="top" width="40%">Display Featured Links above categories in frontend?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("show_flinks", $this->cfg->show_flinks, array('Yes - In All Pages', 'Yes - Only In Directory Home Page', 'No'), array(2,1,0)); ?><?php echo JvleUtil::showTipInfo('If Yes, then the featured links will be displayed in a block above the categories display in directory front-end. Featured links functionality must be enabled for this option to work. You may decide to use the featured links module instead of enabling this option as well'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Which links should be displayed in the front end directory page</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("flinks_dtype", $this->cfg->flinks_dtype, array('recent', 'random'), array('recent', 'random')); ?><?php echo JvleUtil::showTipInfo('Choose among Recent or Random featured links'); ?></td>
    </tr>           
    <tr>
        <td valign="top" width="40%">Number of featured links to be shown in the frontend directory page</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="flinks_numshow" value="<?php echo stripslashes($this->cfg->flinks_numshow); ?>" /><?php echo JvleUtil::showTipInfo('We suggest you make this number short and rotate the links if they are more than this number'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Subscription Amount per month in USD</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="flinks_subamount" value="<?php echo stripslashes($this->cfg->flinks_subamount); ?>" /><?php echo JvleUtil::showTipInfo('This is the amount you will charge for users who want their links to appear in the Featured Links section. It is a monthly subscription'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Your Paypal email address to which the payment needs to be done</td>
        <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="flinks_subemail" value="<?php echo stripslashes($this->cfg->flinks_subemail); ?>" /><?php echo JvleUtil::showTipInfo('<strong>PLEASE ENTER THIS FIELD IF YOU HAVE ENABLED FEATURED LINKS FUNCTIONALITY</strong>'); ?></td>
    </tr>         
</table>               
<?php
    echo $pane->endPanel(); 
    echo $pane->startPanel('Thumbnail Previews',"thumbnails-page");
?>    
<table border="0" cellpadding="3" cellspacing="3" width="100%">
    <tr>
        <td valign="top" width="60%">
            <table border="0" cellpadding="3" cellspacing="3" width="100%">
                <tr>
                    <td valign="top" colspan="2">
                        <h2>Websites Thumbnail Previews in JV-LinkExchanger Pages</h2>
                        <p>Website Thumbnails are screenshots of web pages that can help you quickly and easily recognize and identify websites. Thumbnails for websites, help your visitors navigate online and stay in control of their directory browsing.  <br /><br />JV-LinkExchanger has the ability to display such thumbnails for all the websites listed in your directory. JV-LinkExchanger contacts a provider, fetches the thumbnails and displays them in the directory dynamically. JV-LinkExchanger provides you 2 choices of thumbnail providers - Shrinktheweb.com and Websnapr.com</p>
                    </td>
                </tr>
                <tr>
                	<td valign="top" width="40%"><strong>Enable Thumbnail Previews Feature in JV-LE?</strong></td>
                    <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("tp_enable", $this->cfg->tp_enable, array('Yes - Use Websnapr.com as provider','Yes - Use Shrinktheweb.com as provider','No'), array('2','1','0')); ?><?php echo JvleUtil::showTipInfo('Do you want to use the thumbnail previews feature in JV-LE? If yes choose the provider as well'); ?></td>
                </tr>
                <tr><td valign="top" colspan="2" style="background-color: #e1f2f3;"><strong>Shrinktheweb.com Options</strong></td></tr>
                <tr><td valign="top" colspan="2">All you will need now is a free account at <a href="<?php echo _JVLE_STW_REGISTER_URL; ?>" target="_target">www.shrinktheweb.com</a> and then configure the option below</td></tr>
                <tr>
                    <td valign="top" width="40%"><strong>Your STW Access Key ID</strong></td>
                    <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="stw_access_key" value="<?php echo stripslashes($this->cfg->stw_access_key); ?>" /></td>
                </tr> 
                <tr><td valign="top" colspan="2" style="background-color: #e1f2f3;"><strong>Websnapr.com Options</strong></td></tr>
                <tr><td valign="top" colspan="2">All you will need now is a free account at <a href="<?php echo _JVLE_WEBSNAPR_REGISTER_URL; ?>" target="_target">www.websnapr.com</a> and then configure the option below</td></tr>
                <tr>
                    <td valign="top" width="40%"><strong>Your Websnapr API Key</strong></td>
                    <td valign="top" width="60%"><input type="text" class="inputbox" size="50" maxlength="80" name="websnapr_api_key" value="<?php echo stripslashes($this->cfg->websnapr_api_key); ?>" /></td>
                </tr>                 	
            </table>
        </td>
    </tr>
</table>    
    </tr>                                          
</table>
<?php
    echo $pane->endPanel();     
    echo $pane->startPanel('Misc Options',"misc-page");
?>               
<table class="adminform">
    <tr><td valign="top" colspan="2" style="background-color: #e1f2f3;"><strong>Partner Websites Rating Options</strong></td></tr>
    <tr>
        <td valign="top" width="40%">Can users provide ratings for partner sites?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("enable_link_rating", $this->cfg->enable_link_rating, array('Yes', 'No'), array(1, 0)); ?><?php echo JvleUtil::showTipInfo('If yes, users will be able to provide their rating of individual partner links'); ?></td>
    </tr>   
    <tr>
        <td valign="top" width="40%">Who is authorized to provide rating?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("link_rating_by", $this->cfg->link_rating_by, array('Guest & Registered Users', 'Registered Users'), array('all', 'registered')); ?><?php echo JvleUtil::showTipInfo('Decide if all or only registered users can provide rating. This option is valid, only if "Can users provide ratings for partner websites" is selected to yes'); ?></td>
    </tr>   
    <tr>
        <td valign="top" width="40%">Display Rating along side links in frontend?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("display_ratings", $this->cfg->display_ratings, array('Yes', 'No'), array(1, 0)); ?><?php echo JvleUtil::showTipInfo('If yes, it displays the ratings of websites alongside the links in frontend. This option is valid, only if "Can users provide ratings for partner websites" is selected to yes'); ?></td>
    </tr>           
    
<!-- Next -->
	<tr><td valign="top" colspan="2" style="background-color: #e1f2f3;"><strong>Partner Websites Hit Tracking Options (Applicable only for one-way links added from JV-LE back-end)</strong></td></tr>
    <tr>
        <td valign="top" width="40%">Do you want to track hits to partner sites?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("track_hits", $this->cfg->track_hits, array('Yes', 'No'), array(1, 0)); ?></td>
    </tr>   
    
<!-- Next -->
    <tr><td valign="top" colspan="2" style="background-color: #e1f2f3;"><strong>Check Link Status Options</strong></td></tr>
    <tr>
        <td valign="top" width="40%">Enable "Check Link Status" feature?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("enable_checklinkstatus", $this->cfg->enable_checklinkstatus, array('Yes', 'No'), array(1, 0)); ?><?php echo JvleUtil::showTipInfo('Yes will give a link for users to check the status of their link exchange requests'); ?></td>
    </tr>
        
<!-- Next -->
    <tr><td valign="top" colspan="2" style="background-color: #e1f2f3;"><strong>Recommend a Website Options</strong></td></tr>
    <tr>
        <td valign="top" width="40%">Enable "Recommend a Website" feature?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("enable_recweb", $this->cfg->enable_recweb, array('Yes', 'No'), array(1, 0)); ?><?php echo JvleUtil::showTipInfo('Yes will give a link for users to recommend websites. Recommended website details will be emailed to the administrator'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Who is authorized to provide recommendations?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("recweb_by", $this->cfg->recweb_by, array('Guest & Registered Users', 'Registered Users'), array('all', 'registered')); ?><?php echo JvleUtil::showTipInfo('Decide if all or only registered users can provide recommendations. This option is valid, only if "Recommend a Website" is selected to yes'); ?></td>
    </tr>        
    <tr>
        <td valign="top" width="40%">Recommend a Website Summary</td>
        <td valign="top" width="60%"><textarea class="inputbox" rows="12" cols="60" name="recommend_site_intro"><?php echo stripslashes($this->cfg->recommend_site_intro); ?></textarea><?php echo JvleUtil::showTipInfo('Optional, Summary text at the top of the page where users can recommend websites. Can be used for instructions or for introduction. Valid only if Recommend a Website is enabled. HTML is allowed'); ?></td>
    </tr>
    
<!-- Next -->
    <tr><td valign="top" colspan="2" style="background-color: #e1f2f3;"><strong>Captcha Security Options</strong></td></tr>
    <tr>
        <td valign="top" width="40%">Enable CAPTCHA Security?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("enable_captcha", $this->cfg->enable_captcha, array('Yes', 'No'), array(1, 0)); ?><?php echo JvleUtil::showTipInfo('Yes implies that, user will be presented with a simple mathematical calculation and he must enter the result of the calculation before submitting the forms in frontend. This is an anti-spam technique and a way to prevent automated submissions of forms'); ?></td>
    </tr>    
    
<!-- Next -->
    <tr><td valign="top" colspan="2" style="background-color: #e1f2f3;"><strong>Advertisements Options</strong></td></tr>
    <tr>
        <td valign="top" width="40%">Enable Advertisements in Frontend?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("enable_ads", $this->cfg->enable_ads, array('Yes', 'No'), array(1, 0)); ?><?php echo JvleUtil::showTipInfo('Yes implies that, advertizements will be shown in the directory as defined later below'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Ad to appear betwen Search and Link directory at the top</td>
        <td valign="top" width="60%"><textarea class="inputbox" rows="12" cols="60" name="ad_top"><?php echo stripslashes($this->cfg->ad_top); ?></textarea><?php echo JvleUtil::showTipInfo('Paste the HTML/Javascript Ad code. Use div tag for alignment. If you do not want to place an ad in this position, leave this field blank'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">Ad to appear betwen Link directory and the menu at the bottom</td>
        <td valign="top" width="60%"><textarea class="inputbox" rows="12" cols="60" name="ad_bottom"><?php echo stripslashes($this->cfg->ad_bottom); ?></textarea><?php echo JvleUtil::showTipInfo('Paste the HTML/Javascript Ad code. Use div tag for alignment. If you do not want to place an ad in this position, leave this field blank'); ?></td>
    </tr>
</table>
<?php
    echo $pane->endPanel();
    echo $pane->startPanel('Cron Options',"cron-page");
?>    
<table class="adminform">
    <tr>
        <td valign="top" width="40%">Enable automatic reciprocal link checks via CRON</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("enable_scheduler", $this->cfg->enable_scheduler, array('Yes', 'No'), array(1, 0)); ?><?php echo JvleUtil::showTipInfo('If yes, then all two way links (which have scheduler enabled individually) will be checked by an automatic link checker that is initiated via CRON. Please add a CRON entry in your hosting account for jv-linkexchanger. For instructions and help, please refer to the documentation section of JV-LinkExchanger in forums at www.jv-extensions.com'); ?></td>
    </tr>
    <tr>
        <td valign="top" width="40%">How do you want to view the results of the checker?</td>
        <td valign="top" width="60%"><?php echo JvleUtil::showSelectTag("result_mode", $this->cfg->result_mode, array('E-mail', 'HTML File'), array('email', 'file')); ?><?php echo JvleUtil::showTipInfo('If "email", then the results will be emailed to you in HTML format. If "file", then the results will be stored in an HTML file in {Joomla installation folder}/components/com_jvle/temp folder and you will be notified about this event by email. You may subsequently FTP or view this file in browser'); ?></td>
    </tr>
</table>
<?php
    echo $pane->endPanel();         
    echo $pane->endPane();
?>               
<input type="hidden" name="option" value="com_jvle" />
<input type="hidden" name="controller" value="config" /> 
<input type="hidden" name="task" value="" />
<?php echo JHTML::_('form.token'); ?>
</form>