<?php
/******************************************************************************************
* $Id: view.html.php 106 2011-07-07 10:16:14Z sniranjan $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
jimport("joomla.application.component.view");
//***************************************************************************************************
class JvleViewCategory extends JView
{
    function display($tpl = null)
    {
        jimport('joomla.html.html');
        JHTML::_('behavior.tooltip');

        $layout = JRequest::getVar('layout');
        switch ($layout)
        {
            case "new": $this->showNewCategoryForm($tpl); break;
            case "update": $this->showEditCategoryForm($tpl); break;
            default: $this->displayCategories($tpl); break;
        }
    }
    
    function showNewCategoryForm($tpl)
    {
        $cfg = JvleCfg::getInstance();
                     
        $c_id = $c_name = $c_cpid = $c_alink = array();
        JvleUtil::getTopLevelCategories($c_id, $c_name, $c_cpid, $c_alink);
        
        $this->assignRef('cfg', $cfg);
        $this->assignRef('c_id', $c_id);
        $this->assignRef('c_name', $c_name);
        $this->assignRef('c_cpid', $c_cpid);

        JToolBarHelper::title('JV-LE - Add New Category', 'generic.png');
        JToolBarHelper::save();
        JToolBarHelper::cancel();
        parent::display($tpl);        
    }
    
    function showEditCategoryForm($tpl)
    {              
        $id = JRequest::getInt('id', 0);
        if (!$id)
            return;
        
        $cfg = JvleCfg::getInstance();
        $cobj = JvleDb::getRow("select * from #__jvle_categories where id = '".(int)$id."'");
                
        $c_id = $c_name = $c_cpid = $c_alink = array();
        JvleUtil::getTopLevelCategories($c_id, $c_name, $c_cpid, $c_alink);
        
        $this->assignRef('cfg', $cfg);
        $this->assignRef('id', $id);
        $this->assignRef('c_id', $c_id);
        $this->assignRef('c_name', $c_name);
        $this->assignRef('c_cpid', $c_cpid);
        $this->assignRef('cobj', $cobj); 

        JToolBarHelper::title('JV-LE - Edit Category', 'generic.png');
        JToolBarHelper::save();
        JToolBarHelper::cancel();
        parent::display($tpl);        
    }
           
        
    function displayCategories($tpl)         
    {
        $cfg = JvleCfg::getInstance();
        $model =& $this->getModel();
        
        $cid = $cpid = $cname = $cdesc = $csnap = $cvis = $calinks = $cmaxlinks = array(); 
        $model->getCategoriesList(0, $cid, $cpid, $cname, $cdesc, $cmaxlinks, $csnap, $calinks, $cvis);        
         
        $this->assignRef('cfg', $cfg);
        $this->assignRef('cid', $cid);
        $this->assignRef('cpid', $cpid);
        $this->assignRef('cname', $cname);
        $this->assignRef('cdesc', $cdesc);
        $this->assignRef('cmaxlinks', $cmaxlinks);
        $this->assignRef('csnap', $csnap);
        $this->assignRef('calinks', $calinks);
        $this->assignRef('cvis', $cvis);

        JToolBarHelper::title('JV-LE - Categories', 'generic.png');
        JToolBarHelper::addNew();
        JToolBarHelper::editList('togglesnap','Toggle Snap Status');
        JToolBarHelper::divider();
        JToolBarHelper::deleteList('Are you sure you want to delete the selected categories?');
        JToolBarHelper::divider();         
        JToolBarHelper::back();
        parent::display($tpl);         
    }
}
//***************************************************************************************************