<?php
/******************************************************************************************
* $Id: links.php 98 2011-06-02 15:52:59Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
jimport('joomla.application.component.model');
#*****************************************************************************************
class JvleModelLinks extends JModel 
{
    var $_pagination = null;
    var $_total = null;
    var $_data = null;

    var $retobj = null;    
    
    function __construct()
    {
        parent::__construct();
        
        $mainframe =& JFactory::getApplication();
        $limit = $mainframe->getUserStateFromRequest('global.list.limit','limit',$mainframe->getCfg('list_limit'),'int');
        $limitstart = $mainframe->getUserStateFromRequest('com_jvle.limitstart','limitstart', 0, 'int');
        $limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

        if (!$limit)
            $limit = $this->getTotal();
            
        $this->setState('limit', $limit);
        $this->setState('limitstart', $limitstart);    
        
        $this->retobj = new JvleActionResult;  
    }
    
    function getTotal()
    {
        if (empty($this->_total))
        {
            $cidval = JRequest::getInt('cidval', 0);
            $sql = "select count(id) as CNT from `#__jvle_links`";
            if ($cidval)
                $sql .= " where link_category = '".(int)$cidval."'";
            
            $this->_total = JvleDb::getCount($sql);
        }

        return $this->_total;
    }

    function getData()
    {
        if (empty($this->_data))
        {
            $cidval = JRequest::getInt('cidval', 0);   
            $sql = "select * from `#__jvle_links`"; 
            if ($cidval)
                $sql .= " where link_category = '".(int)$cidval."'";
                           
            $sql .= " order by `link_status` desc limit ".$this->getState('limitstart').", ".$this->getState('limit');        
            $this->_data = JvleDb::getRows($sql);
        }

        return $this->_data;
    }

    function getPagination()
    {
        if (empty($this->_pagination))
        {
            jimport('joomla.html.pagination');            
            $this->_pagination = new JPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit'));
        }
        return $this->_pagination;
    }
    
    function toggleSnap()
    {
        try
        {            
            $rids = array();
            $rids = JRequest::getVar('cid', null, 'post', 'array');
            if (!count($rids))
                throw new Exception('Please select atleast one link');
            
            for ($i=0;$i<count($rids);$i++)
            {
                if (!JvleDb::update("update `#__jvle_links` set `snap_status` = 1-`snap_status` where `id` = '".(int)$rids[$i]."'"))
                    throw new Exception('Database error encountered');                         
            }

            $this->retobj->setMsg(1, 'Snap status has been successfully toggled for the selected links');       
            return;            
        }
        catch (Exception $ex)
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;            
        }                
    }
    
    function deleteLinks()
    {
        try
        {            
            $rids = array();
            $rids = JRequest::getVar('cid', null, 'post', 'array');
            if (!count($rids))
                throw new Exception('Please select atleast one link');
            
            for ($i=0;$i<count($rids);$i++)
            {
                if (!JvleDb::update("delete from #__jvle_links where id = '".(int)$rids[$i]."'"))
                    throw new Exception('Database error encountered');

                JvleDb::update("delete from #__jvle_votes where lid = '".(int)$rids[$i]."'");
            }

            $this->retobj->setMsg(1, 'Selected links have been deleted succesfully.');       
            return;            
        }
        catch (Exception $ex)
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;            
        }                
    }
    
    function approveLinks()
    {
        try
        {            
            $rids = array();
            $rids = JRequest::getVar('cid', null, 'post', 'array');
            if (!count($rids))
                throw new Exception('Please select atleast one link');
            
            for ($i=0;$i<count($rids);$i++)
                JvleUtil::changeLinkStatus($rids[$i], 'ESTABLISHED');

            $this->retobj->setMsg(1, 'Selected links have been approved and partners have been notified succesfully');       
            return;            
        }
        catch (Exception $ex)
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;            
        }                
    }    
    
    function rejectLinks()
    {
        try
        {            
            $rids = array();
            $rids = JRequest::getVar('cid', null, 'post', 'array');
            if (!count($rids))
                throw new Exception('Please select atleast one link');
            
            for ($i=0;$i<count($rids);$i++)
                JvleUtil::changeLinkStatus($rids[$i], 'REJECTED');

            $this->retobj->setMsg(1, 'Selected links have been rejected and partners have been notified succesfully');       
            return;            
        }
        catch (Exception $ex)
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;            
        }                
    }
    
    function changeCategory()
    {
        try
        {
            $cfg = JvleCfg::getInstance();   
            $new_cid = JRequest::getInt('link_category', 0);
            if (!$new_cid)
                throw new Exception('Invalid Request');
                     
            $ids = array();
            $idlist = JRequest::getString('idlist', '');
            if ($idlist == '')
                throw new Exception('Invalid Request');

            $ids = explode(",",$idlist);
            
            $new_catobj = JvleDb::getRow("select * from #__jvle_categories where id = '".(int)$new_cid."'");
            if (($new_catobj->maxlinks) && ((count($ids) + JvleUtil::getNumlinks($new_cid)) > $new_catobj->maxlinks))
                throw new Exception('Operation Failed - Doing this operation will exceed the maximum number of allowed links in the chosen category');
            
            $tlang =& JFactory::getLanguage(); 
            $tlang->load("com_jvle", JPATH_SITE);
                    
            for ($i=0;$i<count($ids);$i++)            
            {
                $lnk = _MOS_LIVESITE.'index.php?option=com_jvle&task=all_category_links&cid='.$new_cid;                
                JvleDb::update("update #__jvle_links set link_category = '".(int)$new_cid."' where id = '".(int)$ids[$i]."'");
                
                $link = JvleDb::getRow("select * from #__jvle_links where id = '".(int)$ids[$i]."'");
                if ($link->partner_email != '')
                {
                    if ($link->exchange_link)
                    {
                        $msg = str_replace("{PARTNER-LINK-LOC}", $lnk, str_replace("{MY-EMAIL}", $cfg->self_email, str_replace("{MY-URL}", $cfg->self_url, JText::_("COM_JVLE_A142"))));
                        JvleUtil::sendEmail($link->partner_email, JText::_("COM_JVLE_A144"), $msg);
                    }
                    else
                    {
                        $msg = str_replace("{PARTNER-LINK-LOC}", $lnk, str_replace("{MY-EMAIL}", $cfg->self_email, str_replace("{MY-URL}", $cfg->self_url, JText::_("COM_JVLE_A143"))));
                        JvleUtil::sendEmail($link->partner_email, JText::_("COM_JVLE_A145"), $msg);
                    }                    
                }
            }            
                            
            $this->retobj->setMsg(1, 'Selected links have been moved to the chosen category');       
            return;            
        }
        catch (Exception $ex)
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;            
        }        
    }
        
    function store()
    {
        $mode = JRequest::getInt('mode');
        switch ($mode)
        {
            case 3: return $this->changeCategory(); break;
            case 11: return $this->addLink(1); break;
            case 12: return $this->addLink(2); break;
            case 21: return $this->editLink(1); break;
            case 22: return $this->editLink(2); break;
            default: break;
        }
        
        return;
    }

    function addLink($direction)
    {
        try 
        {
            $cfg = JvleCfg::getInstance();
            
            $partner_url = JRequest::getString('partner_url', '');
            $partner_email = JRequest::getString('partner_email', '');
            $partner_title = JRequest::getString('partner_title', '');
            $partner_desc = JRequest::getString('partner_desc', '');
            $snap_status = JRequest::getInt('snap_status', 0);
            $enable_scheduler = JRequest::getInt('enable_scheduler', 0);
            $featured = JRequest::getInt('featured', 0);
            $link_category = JRequest::getInt('link_category', 0);
            $exchange_link = JRequest::getInt('exchange_link', 99);            
            $reciprocal_link_url = ($direction == 2) ? JRequest::getString('reciprocal_link_url', '') : '';
            
            if ($partner_url == '')
                throw new Exception('Please provide the partner URL');
                
            if ($exchange_link == 99)
                throw new Exception('Please select if you want to add a text based link or banner based link');
            
            if (($exchange_link) && ($partner_title == ''))
                throw new Exception('Please provide the partner title, as you want to exchange link with partner');

            if (!$link_category)
                throw new Exception('Please select a category');
                
            $partner_url = JvleUtil::stripLastChar($partner_url);

            if (!JvleUtil::isNewLink($partner_url))
                throw new Exception('Duplicate link/banner detected: This link/banner is already listed in your directory');         
           
            $catobj = JvleDb::getRow("select maxlinks from #__jvle_categories where id = '".(int)$link_category."'");
            if (($catobj->maxlinks) && ((1 + JvleUtil::getNumlinks($link_category)) > $catobj->maxlinks))
                throw new Exception('Operation Failed - Doing this operation will exceed the maximum number of allowed links in the chosen category');
           
            $banner_file = '';  
            if (!$exchange_link)
            {                
               $ret = JvleUtil::uploadFile('partner_banner', _MOS_ABS_BANNERS, $banner_file, $cfg->banner_extns, $cfg->banner_kbsize_max, $cfg->banner_width_max, $cfg->banner_height_max);                   
               switch ($ret)
               {
                   case 1: throw new Exception('Banner file extension is not allowed'); break;
                   case 2: throw new Exception('Banner Upload failed - Please check the permissions for folder: '._MOS_ABS_BANNERS); break;
                   case 3: throw new Exception('Banner dimensions are more than allowed values'); break;
                   case 4: throw new Exception('Banner not uploaded'); break;
                   case 5: throw new Exception('Banner size exceeds maximum allowed value of '.$cfg->banner_kbsize_max.' KB'); break;
                   default: break;
                }              
            }
            
            $link_added_on = time();
            if ($direction == 1)
            {
                $link_type = 'ONE-WAY';
                $link_status = 'ESTABLISHED';                
                $link_published_on = time();    
            }
            else
            {
                $link_type = 'TWO-WAY';
                $link_status = 'PENDING';
                $link_published_on = 0;
            }            
            
            $sql = "insert into #__jvle_links values(NULL,'".$link_type."','".JvleSecure::defendSQL($partner_title)."','".JvleSecure::defendSQL($partner_url)."','".JvleSecure::defendSQL($partner_desc)."','".JvleSecure::defendSQL($partner_email)."','".JvleSecure::defendSQL($reciprocal_link_url)."','".(int)$link_category."','".$link_status."','".$link_added_on."','".$link_published_on."','0','0','0','','','0','".(int)$snap_status."','".(int)$enable_scheduler."','".(int)$featured."','".(int)$exchange_link."','".JvleSecure::defendSQL($banner_file)."','0')";
            if (!JvleDb::update($sql))
                throw new Exception('Database error encountered');
            
            $msg = "Dear Webmaster,\n\nThis is to confirm that, you have added a new link/banner to, ".$partner_url." in your link directory using the Joomla backend and the current status of the link is ".$link_status."\n\nThanks\n".$cfg->self_url;
            JvleUtil::sendEmail($cfg->self_email, 'Confirmation: New link added at backend '.$cfg->self_url, $msg);
            
            $lnk = _MOS_LIVESITE.'index.php?option=com_jvle&task=all_category_links&cid='.$link_category;                      
            $this->retobj->setMsg(1, 'New Link has been added successfully. You can view the added link at: '.$lnk);       
            return;
        } 
        catch (Exception $ex) 
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;
        }
    }
            
    function editLink($direction)
    {
        try 
        {
            $cfg = JvleCfg::getInstance();
            
            $id = JRequest::getInt('id', 0); 
            $partner_url = JRequest::getString('partner_url', '');
            $reciprocal_link_url = ($direction == 2) ? JRequest::getString('reciprocal_link_url', '') : '';            
            $partner_email = JRequest::getString('partner_email', '');
            $snap_status = JRequest::getInt('snap_status', 0);
            $enable_scheduler = JRequest::getInt('enable_scheduler', 0);
            $featured = JRequest::getInt('featured', 0);
            $partner_title = JRequest::getString('partner_title', '');
            $partner_desc = JRequest::getString('partner_desc', '');
            $reject_reason = JRequest::getString('reject_reason', '');
            $link_status = JRequest::getString('link_status', '');
            $exchange_link = JRequest::getInt('exchange_link', 1);            
            
            if (!$id)
                throw new Exception('Invalid Request'); 
                
            $clink = JvleDb::getRow("select * from #__jvle_links where id = '".(int)$id."'");
            
            if ($partner_url == '')
                throw new Exception('Please provide the partner URL');
                
            if (($exchange_link) && ($partner_title == ''))
                throw new Exception('Please provide the partner title, as you want to exchange link with partner');

            $partner_url = JvleUtil::stripLastChar($partner_url);
            
            if (($link_status == 'REJECTED') && ($reject_reason == ''))
                throw new Exception('You must provide a reason for rejection');

            $banner_file = $clink->banner_loc;  
            if (!$exchange_link)
            {                
               $ret = JvleUtil::uploadFile('partner_banner', _MOS_ABS_BANNERS, $banner_file, $cfg->banner_extns, $cfg->banner_kbsize_max, $cfg->banner_width_max, $cfg->banner_height_max);                   
               switch ($ret)
               {
                   case 1: throw new Exception('Banner file extension is not allowed'); break;
                   case 2: throw new Exception('Banner Upload failed - Please check the permissions for folder: '._MOS_ABS_BANNERS); break;
                   case 3: throw new Exception('Banner dimensions are more than allowed values'); break;
                   case 4: break;
                   case 5: throw new Exception('Banner size exceeds maximum allowed value of '.$cfg->banner_kbsize_max.' KB'); break;
                   default: break;
                }              
            }

            $sql = "update #__jvle_links set 
                        partner_title = '".JvleSecure::defendSQL($partner_title)."', 
                        partner_url = '".JvleSecure::defendSQL($partner_url)."', 
                        partner_desc = '".JvleSecure::defendSQL($partner_desc)."', 
                        reciprocal_link_url = '".JvleSecure::defendSQL($reciprocal_link_url)."', 
                        partner_email = '".JvleSecure::defendSQL($partner_email)."', 
                        snap_status = '".(int)$snap_status."',                
                        enable_scheduler = '".(int)$enable_scheduler."',                
                        featured = '".(int)$featured."',     
                        exchange_link = '".(int)$exchange_link."',
                        reject_reason = '".JvleSecure::defendSQL($reject_reason)."',                  
                        banner_loc = '".JvleSecure::defendSQL($banner_file)."'                  
                    where id = '".(int)$id."'";
                
            if (!JvleDb::update($sql))
                throw new Exception('Database error encountered');
                
            JvleUtil::changeLinkStatus($id, $link_status, $reject_reason);
            $this->retobj->setMsg(1, 'Link/Banner has been edited successfully');       
            return;
        } 
        catch (Exception $ex) 
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;
        }
    }
}