<?php
/******************************************************************************************
* $Id: category.php 98 2011-06-02 15:52:59Z vijay $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access'); 
jimport('joomla.application.component.model');
#*****************************************************************************************
class JvleModelCategory extends JModel 
{
    var $retobj = null;
    
    function __construct()
    {
        parent::__construct();        
        $this->retobj = new JvleActionResult;    
    }

    function toggleSnap()
    {
        try
        {            
            $rids = array();
            $rids = JRequest::getVar('cid', null, 'post', 'array');
            if (!count($rids))
                throw new Exception('Please select atleast one category');
            
            for ($i=0;$i<count($rids);$i++)
            {
                if (!JvleDb::update("update `#__jvle_categories` set `snap_status` = 1-`snap_status` where `id` = '".(int)$rids[$i]."'"))
                    throw new Exception('Database error encountered');                         
            }

            $this->retobj->setMsg(1, 'Snap status has been successfully toggled for the selected categories');       
            return;            
        }
        catch (Exception $ex)
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;            
        }                
    }
    
    function deleteCategories()
    {
        try
        {            
            $rids = array();
            $rids = JRequest::getVar('cid', null, 'post', 'array');
            if (!count($rids))
                throw new Exception('Please select atleast one category');
            
            $donecnt = 0;
            for ($i=0;$i<count($rids);$i++)
            {
                if (JvleUtil::getNumlinks($rids[$i]))
                    continue;
                
                $cnt = JvleDb::getCount("select count(id) as CNT from #__jvle_categories where cpid = '".(int)$rids[$i]."'");
                if ($cnt)
                    continue;
                
                if (!JvleDb::update("delete from #__jvle_categories where id = '".(int)$rids[$i]."'"))
                    throw new Exception('Database error encountered');
                
                $donecnt++;                         
            }

            $this->retobj->setMsg(1, 'Selected categories have been deleted succesfully.');       
            return;            
        }
        catch (Exception $ex)
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;            
        }                
    }
    
    function getCategoriesList($sel_cid, &$id, &$cpid, &$name, &$desc, &$maxlinks, &$snap, &$alinks, &$vis)
    {
        $rows = JvleDb::getRows("select * from `#__jvle_categories` where `cpid` = '".(int)$sel_cid."' order by `name` asc");        
        if (!count($rows))
            return;    
        
        foreach ($rows as $cat)
        {
            array_push($id, $cat->id);            
            array_push($cpid, $cat->cpid);
            array_push($name, $cat->name);
            array_push($desc, $cat->description);
            array_push($maxlinks, $cat->maxlinks);            
            array_push($snap, $cat->snap_status);
            array_push($alinks, $cat->accept_links);
            array_push($vis, $cat->visibility);

            $this->getCategoriesList($cat->id, $id, $cpid, $name, $desc, $maxlinks, $snap, $alinks, $vis); 
        }
        
        return;
    }

    function store()
    {
        $mode = JRequest::getInt('mode');
        switch ($mode)
        {
            case 1: return $this->addCategory(); break;
            case 2: return $this->updateCategory(); break;
            default: break;
        }
        
        return;
    }
    
    function addCategory()
    {
        try 
        {
            $cname = JRequest::getString('cname', '');
            $cdesc = JRequest::getString('cdesc', '');
            $cmaxlinks = JRequest::getInt('cmaxlinks', 0);
            $snap_status = JRequest::getInt('snap_status', 0); 
            $accept_links = JRequest::getInt('accept_links', 1); 
            $visibility = JRequest::getInt('visibility', 1);
            $cpid = JRequest::getInt('cpid', 0);
            
            if ($cname == '')
                throw new Exception('Please provide all the necessary information to proceed');
                
            if (JString::strtolower($cname) == 'links')
                throw new Exception('links is not allowed as category name');
                
            if (strstr($cname, "_") != NULL)
                throw new Exception('Category name cannot contain underscore in it');
                
            $cnt = JvleDb::getCount("select count(id) as CNT from #__jvle_categories where `name` = '".JvleSecure::defendSQL($cname)."'");
            if ($cnt)
                throw new Exception('Another category with the same name already exists');         
                
            if (!JvleDb::update("insert into `#__jvle_categories` values('','".(int)$cpid."','".JvleSecure::defendSQL($cname)."','".JvleSecure::defendSQL($cdesc)."','".(int)$cmaxlinks."','".(int)$snap_status."','".(int)$accept_links."','".(int)$visibility."')"))
                throw new Exception('Database error encountered');         
             
             $this->retobj->setMsg(1, 'New Category has been added successfully');       
             return;
        } 
        catch (Exception $ex) 
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;
        }
    }
            
    function updateCategory()
    {
        try 
        {
            $cname = JRequest::getString('cname', '');
            $cdesc = JRequest::getString('cdesc', '');
            $cmaxlinks = JRequest::getInt('cmaxlinks', 0);
            $snap_status = JRequest::getInt('snap_status', 0); 
            $accept_links = JRequest::getInt('accept_links', 1); 
            $visibility = JRequest::getInt('visibility', 1);
            $cpid = JRequest::getInt('cpid', 0);
            $id = JRequest::getInt('id', 0);
            
            if (!$id)
                throw new Exception('Invalid request');
                
            if ($cname == '')
                throw new Exception('Please provide all the necessary information to proceed');
                
            if (JString::strtolower($cname) == 'links')
                throw new Exception('links is not allowed as category name');
                
            if (strstr($cname, "_") != NULL)
                throw new Exception('Category name cannot contain underscore in it');
                
            if (!JvleDb::update("update `#__jvle_categories` set cpid = '".(int)$cpid."', `name` = '".JvleSecure::defendSQL($cname)."', `description` = '".JvleSecure::defendSQL($cdesc)."', maxlinks = '".(int)$cmaxlinks."', snap_status = '".(int)$snap_status."', accept_links = '".(int)$accept_links."', visibility = '".(int)$visibility."' where id = '".(int)$id."'"))
                throw new Exception('Database error encountered');         
             
             $this->retobj->setMsg(1, 'Category has been updated successfully');       
             return;
        } 
        catch (Exception $ex) 
        {
            $this->retobj->setMsg(0, $ex->getMessage());       
            return;
        }
    }

}