<?php
/******************************************************************************************
* $Id: jvle.utilities.php 108 2011-07-07 10:49:41Z sniranjan $
* 
* JV-LinkExchanger - Basic Link and Banner Exchange Extension for Joomla!
* Copyright 2007-2011 JV-Extensions
* 
* This file is part of JV-LinkExchanger
* 
* JV-LinkExchanger is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* JV-LinkExchanger is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
* 
* @author JV-Extensions
* @link http://www.jv-extensions.com
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
******************************************************************************************/
defined('_JEXEC') or die('Restricted access');
#************************************************************************************************************
abstract class JvleUtil
{
    const VERSIONCHECK_URL = "http://www.jv-extensions.com/versioncheck.php?pid=jvle";
    const NEWS_FEED_URL = "http://www.jv-extensions.com/index.php?app=core&module=global&section=rss&type=forums&id=1";    
    
    public static function getLatestVersion() {
        if (!function_exists('curl_init'))
            return;
            
        $ch = @curl_init(self::VERSIONCHECK_URL);
        if ($ch == FALSE) return 2;
        @curl_setopt($ch, CURLOPT_HEADER, 0);
        @curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        @curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 4);
        @curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $resp = @curl_exec($ch);
        @curl_close($ch);
        
        $tokens = explode("|",$resp);        
        return JString::trim($tokens[1]);
    }
        
    public static function stripLastChar($url)
    {
        return (JString::substr($url, JString::strlen($url)-1, 1) == "/") ? JString::substr($url, 0, JString::strlen($url)-1) : $url;
    }
    
    public static function getLiveSiteURL()
    {
        $site_root = JURI::root();
        return (JString::substr($site_root, JString::strlen($site_root)-1, 1) == '/') ? $site_root : $site_root . '/';        
    }    

    public static function showTipInfo($info)
    {
        if ($info != '')
            return '<br /><small>'.$info.'</small>';
    }
    
    public static function showRequired()
    {
        echo '<strong><font color="red">*</font></strong> ';
    }
    
    public static function showSelectTag($tagname, $fname, $optvar, $optval, $jsfunc='') 
    {
        $ret = "";
        $ret .= '<select name="'.$tagname.'" id="'.$tagname.'" '.$jsfunc.'>';
        for ($i=0;$i<count($optvar);$i++)
        {
            $t = ($fname == $optval[$i]) ? 'selected="selected"' : '';            
            $ret .= '<option value="'.$optval[$i].'" '.$t.'>'.$optvar[$i].'</option>';
        }
        $ret .= '</select>';
        return $ret;        
    }

    public static function checkSelected($t1, $t2)
    {
        return ($t1 == $t2) ? 'selected="selected"' : '';
    }    
    
    public static function getCategories($sel_cid, &$c_id, &$c_name, &$c_cpid, &$c_alink)
    {
        $rows = JvleDb::getRows("select * from `#__jvle_categories` where `cpid` = '".(int)$sel_cid."' order by `name` asc");
        if (count($rows))
        {
            foreach($rows as $catg)
            {
                array_push($c_id, $catg->id);
                array_push($c_name, $catg->name);                
                array_push($c_cpid, $catg->cpid);
                array_push($c_alink, $catg->accept_links);
                JvleUtil::getCategories($catg->id, $c_id, $c_name, $c_cpid, $c_alink);
            }
        }
    }
    
    public static function getTopLevelCategories(&$c_id, &$c_name, &$c_cpid, &$c_alink) 
    {
        $rows = JvleDb::getRows("select * from `#__jvle_categories` where `cpid` = '0' order by `name` asc");
        if (count($rows))
        {
            foreach($rows as $catg)
            {
                array_push($c_id, $catg->id);
                array_push($c_name, $catg->name);                
                array_push($c_cpid, $catg->cpid);
                array_push($c_alink, $catg->accept_links);
            }
        }
    }
    
    public static function getNumlinks($cid, $anystatus=1)
    {
        $sql = ($anystatus) ? "select count(*) as CNT from #__jvle_links where link_category = '".(int)$cid."'" : "select count(*) as CNT from #__jvle_links where link_category = '".(int)$cid."' and link_status = 'ESTABLISHED'";
        return JvleDb::getCount($sql);
    }
    
    public static function getCategoryName($cid)        
    {
        $obj = JvleDb::getRow("select id, name from #__jvle_categories where id = '".(int)$cid."'");
        return $obj->name;
    }
    
    public static function changeLinkStatus($id, $new_status, $reject_reason='')
    {
        $link = JvleDb::getRow("select * from #__jvle_links where id = '".(int)$id."'");
        if (!$link)
            return;
            
        if ($link->link_status == $new_status)
            return;
            
        $tlang =& JFactory::getLanguage(); 
        $tlang->load("com_jvle", JPATH_SITE);
        
        $cfg = JvleCfg::getInstance();
        switch ($new_status)
        {
            case 'ESTABLISHED':
            {
                JvleDb::update("update #__jvle_links set link_status = 'ESTABLISHED', link_published_on = '".time()."' where id = '".(int)$id."'");
                if ($link->partner_email != '')
                {
                    $lnk = _MOS_LIVESITE.'index.php?option=com_jvle&Itemid='._JVLE_ITEMID.'&task=all_category_links&cid='.$link->link_category;
                    if ($link->exchange_link)
                    {
                        $msg = str_replace("{MY-URL}", $cfg->self_url, str_replace("{MY-EMAIL}", $cfg->self_email, str_replace("{PARTNER-LINK-LOC}", $lnk, JText::_("COM_JVLE_A136"))));
                        JvleUtil::sendEmail($link->partner_email, JText::_("COM_JVLE_A112"), $msg);
                    }
                    else
                    {
                        $msg = str_replace("{MY-URL}", $cfg->self_url, str_replace("{MY-EMAIL}", $cfg->self_email, str_replace("{PARTNER-LINK-LOC}", $lnk, JText::_("COM_JVLE_A137"))));                        
                        JvleUtil::sendEmail($link->partner_email, JText::_("COM_JVLE_A133"), $msg);                        
                    }
                }
                break;
            }
            case 'REJECTED':
            {
                $rreason = ($reject_reason != '') ? $reject_reason : $cfg->generic_reject_reason;
                    
                JvleDb::update("update #__jvle_links set link_status = 'REJECTED' where id = '".(int)$id."'");
                if ($link->partner_email != '')
                {
                    if ($link->exchange_link)
                    {
                        $msg = JText::_("COM_JVLE_A138");
                        if ($rreason != '')
                            $msg .= str_replace("{REASON}", stripslashes($rreason), JText::_("COM_JVLE_A139"));
                            
                        $msg .= str_replace("{MY-EMAIL}", $cfg->self_email, str_replace("{MY-URL}", $cfg->self_url, JText::_("COM_JVLE_A140")));                       
                        JvleUtil::sendEmail($link->partner_email, JText::_("COM_JVLE_A134"), $msg);
                    }
                    else
                    {
                        $msg = JText::_("COM_JVLE_A141");
                        if ($rreason != '')
                            $msg .= str_replace("{REASON}", stripslashes($rreason), JText::_("COM_JVLE_A139"));

                        $msg .= str_replace("{MY-EMAIL}", $cfg->self_email, str_replace("{MY-URL}", $cfg->self_url, JText::_("COM_JVLE_A140")));
                        JvleUtil::sendEmail($link->partner_email, JText::_("COM_JVLE_A135"), $msg);                        
                    }                    
                }
                break;    
            }
            default:
            {
                JvleDb::update("update #__jvle_links set link_status = '".JvleSecure::defendSQL($new_status)."', link_published_on = '0' where id = '".(int)$id."'");
                break;
            }
        }
        
        return;
    }

    public static function getRemoteSitePageByCurl($partner_page)
    {        
        $ch = @curl_init($partner_page);
        if ($ch == FALSE) 
            return null;    
            
        @curl_setopt($ch, CURLOPT_HEADER, 1);
        @curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        @curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        @curl_setopt($ch, CURLOPT_USERAGENT, 'PHP Client');
        @curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        @curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
        @curl_setopt($ch, CURLOPT_MAXREDIRS, 5);        
        $resp = @curl_exec($ch);
        
        if (@curl_error($ch) != '') { @curl_close($ch); return null; }
        @curl_close($ch);
        
        return ($resp != '') ? $resp : null;
    }

    public static function getRemoteSitePageBySocket($partner_page)
    {  
        if (function_exists("fsockopen"))      
        {
            preg_match("/^(http:\/\/)?([^\/]+)/i", $partner_page, $hostname);
            $host = $hostname[2];
            $tail = str_replace($hostname[0], "", $partner_page);
            for($x=0;$x<2;$x++) 
            {
                $resp = "";
                $startfile = @fsockopen($host, '80');             
                if ($startfile) 
                {    
                    $page = (JString::trim($tail) == "") ? "/" : $tail;                
                    fputs($startfile, "GET ".$page." HTTP/1.0\r\nHost: ".$host."\r\nUser-Agent: PHP Client\r\n\r\n");
                    while(!feof($startfile)) 
                        $resp .= fgets($startfile, 10240);
                    fclose($startfile);                   
                    return $resp;
                }
            }                    
        }

        return null;
    }

    public static function getRemoteSitePage($partner_page)
    {
        if (function_exists("curl_init"))
        {
            $resp = JvleUtil::getRemoteSitePageByCurl($partner_page);
            return (($resp == null) ? JvleUtil::getRemoteSitePageBySocket($partner_page) : $resp);
        }
        else
            return JvleUtil::getRemoteSitePageBySocket($partner_page);
    }

    public static function checkReciprocalLink($siteurl, $recip)
    {
        $recip = JString::strtolower(JString::trim($recip, "/ "));        
        $indexfile = JvleUtil::getRemoteSitePage($siteurl);
        return ($indexfile != null) ? JvleUtil::validateBackLink($indexfile, $recip) : 1;
    }

    public static function validateBackLink($content, $url_to_find)
    {
        $search_pattern = "/<a(.*?)>(.*?)<\/a>/is";
        preg_match_all($search_pattern, $content, $matches);
        
        $url_to_find_alt1 = (JString::substr($url_to_find, 7, 4) == 'www.') ? 'http://'.JString::substr($url_to_find, 11) : 'http://www.'.JString::substr($url_to_find, 7);
        
        for ($url_in=0,$i=0;$i<count($matches[1]);$i++)
        {
            $atag = '<a '.$matches[1][$i].'>';
            $url_in_partner_page = JString::strtolower(JString::trim(JvleUtil::getATagParam(" href", $atag), "/ "));

            if ((JString::substr($url_in_partner_page, 0, JString::strlen($url_to_find)) == $url_to_find) ||
            	(JString::substr($url_in_partner_page, 0, JString::strlen($url_to_find_alt1)) == $url_to_find_alt1))            		 
            {
                $url_in = 1;    
                break;                    
            }      
        }
        
        return ($url_in) ? ((JString::strtolower(JString::trim(JvleUtil::getATagParam(" rel", $atag))) == 'nofollow') ? 2 : 0) : 3;
    }    

    public static function getATagParam($param, $tag)
    {
        return (preg_match('/'.preg_quote($param).'=([\'"])?((?(1).+?|[^\s>]+))(?(1)\1)/is', $tag, $match)) ? urldecode($match[2]) : '';
    }

    public static function isNewLink($url)
    {
        preg_match("/^(http:\/\/)?([^\/]+)/i",$url, $hostname);
        $host = $hostname[2];

        if (JString::substr($host, 0, 4) == 'www.')
        {
            $host1 = $host;
            $host = JString::substr($host, 4);
        }
        else
        {
            $host1 = "www.".$host;
            $host = $host;
        }

        $row = JvleDb::getRow("select * from #__jvle_links where partner_url = 'http://".JvleSecure::defendSQL($host)."' or partner_url = 'http://".JvleSecure::defendSQL($host1)."'");
        return (!$row) ? 1 : 0;        
    }
    
    /* DG:3-S */
    public static function getTargetString()
    {
        $cfg = JvleCfg::getInstance();
        return ($cfg->window_new) ? ' target="_blank" ' : '';    
    }
    /* DG:3-F */
    
    public static function uploadFile($filefield, $destpath, &$mfilename, $allowed_extns='gif,jpg,png', $maxsize=1000, $width=1000, $height=1000)
    {
        $file = JRequest::getVar($filefield, null, 'files', 'array');
        if ((!isset($file['name'])) || ($file['name'] == '') || (empty($file['name'])))
            return 4;
                
        jimport('joomla.filesystem.file');        
        $filename = JFile::makeSafe($file['name']);
        
        if ($allowed_extns != '')
        {
            $allow = explode(',',$allowed_extns);
            if (!in_array(JString::strtolower(JFile::getExt($filename)), $allow))
                return 1;
        }
        
        if ($width && $height)
        {
            list ($w1, $h1, $typ, $w2) = getimagesize($file['tmp_name']);
            if (($w1 > $width) || ($h1 > $height))
                return 3;
        }
        
        if ($maxsize)
        {
            $fsize = round(filesize($file['tmp_name'])/1024, 2); 
            if ($fsize > $maxsize)
                return 5;
        }
        
        $src = $file['tmp_name'];
        $mfilename = time()."_".$filename;
        $dest = $destpath.DS.$mfilename;
        
        if (!JFile::upload($src, $dest))
            return 2;
        
        return 0;
    }
    
    /* DG:6-S */
    public static function updateLastRecipDate($id) {
        JvleDb::update("update #__jvle_links set rlc_last_checked_on = '".time()."' where id = '".(int)$id."'");    
    }
    /* DG:6-F */
    
    public static function sendEmail($toaddr, $subject, $content, $mode=0) {
    	$cfg = JvleCfg::getInstance();
    
    	if (_JVLE_J16) {
    		$mailer = JFactory::getMailer();
    		$mailer->sendMail($cfg->self_email, $cfg->self_email, $toaddr, $subject, $content, $mode);
    	} else {
    		$mailer =& JFactory::getMailer();
    		$mailer->isHTML($mode);
    
    		$mailer->to = array();
    		$mailer->cc = array();
    		$mailer->bcc = array();
    
    		$mailer->addRecipient($toaddr);
    		$mailer->setSubject($subject);
    		$mailer->setBody($content);
    		$mailer->Send();
    	}
    	return;
    }    
}
#***********************************************************************************************