<?php
/**
 * jUpgrade
 *
 * @version		  $Id$
 * @package		  MatWare
 * @subpackage	com_jupgrade
 * @author      Matias Aguirre <maguirre@matware.com.ar>
 * @link        http://www.matware.com.ar
 * @copyright		Copyright 2006 - 2011 Matias Aguire. All rights reserved.
 * @license		  GNU General Public License version 2 or later; see LICENSE.txt
 */

/**
 * Upgrade class for Weblinks
 *
 * This class takes the weblinks from the existing site and inserts them into the new site.
 *
 * @since	0.4.5
 */
class jUpgradeWeblinks extends jUpgrade
{
	/**
	 * @var		string	The name of the source database table.
	 * @since	0.4.5
	 */
	protected $source = '#__weblinks';

	/**
	 * Get the raw data for this part of the upgrade.
	 *
	 * @return	array	Returns a reference to the source data array.
	 * @since	0.4.5
	 * @throws	Exception
	 */
	protected function &getSourceData()
	{
		$rows = parent::getSourceData(
			'`id`, `catid`, `sid`, `title`, `alias`, `url`, `description`, `date`, `hits`, '
     .' `published` AS state, `checked_out`, `checked_out_time`, `ordering`, `archived`, `approved`,`params`',
			null,
			'id'
		);

		// Getting the categories id's
		$categories = $this->getMapList('categories', 'com_weblinks');

		// Do some custom post processing on the list.
		foreach ($rows as &$row)
		{
			// Convert HTML entities to UTF-8 on escaped entries
			$row['title'] = $this->entities2Utf8($row['title']);
			
			$row['params'] = $this->convertParams($row['params']);

			$cid = $row['catid'];
			$row['catid'] = &$categories[$cid]->new;
		}

		return $rows;
	}
}
