<?php
/**
 * Log view
 *
 * The logger needs to record several messages. These are:
 * - Successful imported records
 * - Failed imported records
 * - Status messages
 * - Warning messages
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: view.html.php 1574 2011-04-16 15:00:03Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.view' );

/**
 * Log View
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartViewLog extends JView {
	
	/**
	* Log view display method
	* @return void
	*/
	function display($tpl = null) {
		// Get the task
		$task = JRequest::getCmd('task');
		// Load a log ID
		$cid = JRequest::getVar('cid');
		// Get the log
		$model = $this->getModel('log');
		
		if (isset($cid[0])) $model->setId($cid[0]);
		switch ($task) {
			case 'logreader':
				$this->logdetails = $this->get('Logfile');
				$this->logfile = $logfile = CSVIPATH_DEBUG.'/com_csvivirtuemart.log.'.JRequest::getInt('run_id').'.php';
				break;
			default:
				// Get the pagination
				$pagination = $this->get('Pagination');
				// Load the logs
				$logentries = $this->get('LogEntries');
				// Load the action types
				$actiontypes = $this->get('ActionTypes');
				$lists['actions'] = JHTML::_('select.genericlist', $actiontypes, 'filter_actiontype', '', 'value', 'text', JRequest::getWord('filter_actiontype'));
				// Assign variables
				$this->assignRef('logentries', $logentries);
				$this->assignRef('pagination', $pagination);
				$this->assignRef('lists', $lists);
				// Add toolbar
				JToolBarHelper::title(JText::_('COM_CSVIVIRTUEMART_LOG'), 'csvivirtuemart_log_48');
				JToolBarHelper::custom( 'logdetails', 'csvivirtuemart_logdetails_32', 'csvivirtuemart_logdetails_32', JText::_('COM_CSVIVIRTUEMART_DETAILS'), true);
				JToolBarHelper::custom( 'remove', 'csvivirtuemart_delete_32', 'csvivirtuemart_delete_32', JText::_('COM_CSVIVIRTUEMART_DELETE'), true);
				JToolBarHelper::custom( 'remove_all', 'csvivirtuemart_delete_32', 'csvivirtuemart_delete_32', JText::_('COM_CSVIVIRTUEMART_DELETE_ALL'), false);
				JToolBarHelper::help('log.html', true);
				break;
		}
		
		// Display it all
		parent::display($tpl);
	}
}
?>