<?php
/**
 * Log results
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Log
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: default.php 1574 2011-04-16 15:00:03Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' ); 
?>
<form action="index.php" method="post" name="adminForm">
	<div id="filterbox">
		<?php echo JText::_('COM_CSVIVIRTUEMART_FILTER'); ?>:
		<?php echo $this->lists['actions']; ?>
		<input type="submit" onclick="this.form.submit();" value="<?php echo JText::_('COM_CSVIVIRTUEMART_GO'); ?>" />
		<input type="submit" onclick="document.adminForm.filter_actiontype.value = '';" value="<?php echo JText::_('COM_CSVIVIRTUEMART_RESET'); ?>" />
		<div class="resultscounter"><?php echo $this->pagination->getResultsCounter(); ?></div>
	</div>
	<div id="availablefieldslist" style="text-align: left;">
		<table class="adminlist" id="logs">
			<thead>
			<tr>
				<th width="20">
				<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($this->logentries); ?>);" />
				</th>
				<th class="title">
				<?php echo JText::_('COM_CSVIVIRTUEMART_ACTION'); ?>
				</th>
				<th class="title">
				<?php echo JText::_('COM_CSVIVIRTUEMART_ACTION_TYPE'); ?>
				</th>
				<th class="title">
				<?php echo JText::_('COM_CSVIVIRTUEMART_TEMPLATE_NAME_TITLE'); ?>
				</th>
				<th class="title">
				<?php echo JText::_('COM_CSVIVIRTUEMART_TIMESTAMP'); ?>
				</th>
				<th class="title">
				<?php echo JText::_('COM_CSVIVIRTUEMART_USER'); ?>
				</th>
				<th class="title">
				<?php echo JText::_('COM_CSVIVIRTUEMART_RECORDS'); ?>
				</th>
				<th class="title">
				<?php echo JText::_('COM_CSVIVIRTUEMART_RUN_CANCELLED'); ?>
				</th>
				<th class="title">
				<?php echo JText::_('COM_CSVIVIRTUEMART_FILENAME'); ?>
				</th>
				<th class="title">
				<?php echo JText::_('COM_CSVIVIRTUEMART_RUN_ID'); ?>
				</th>
			</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="10"><?php echo $this->pagination->getListFooter(); ?></td>
				</tr>
			</tfoot>
			<tbody>
			<?php
			//* Check for logentries
			if ($this->logentries) {
				for ($i=0, $n=count( $this->logentries); $i < $n; $i++) {
					$row = $this->logentries[$i];
					// Pseudo entry for satisfying Joomla 
					$row->checked_out = 0;
					
					$link 	= 'index.php?option=com_csvivirtuemart&view=logdetails&run_id='. $row->run_id;
					$checked = JHTML::_('grid.checkedout',  $row, $i, 'run_id');
					$user = JFactory::getUser($row->userid);
					?>
					<tr>
						<td>
						<?php echo $checked; ?>
						</td>
						<td>
							<a href="<?php echo $link; ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_'.$row->action); ?></a>
						</td>
						<td>
							<?php echo JText::_('COM_CSVIVIRTUEMART_'.$row->action_type); ?>
						</td>
						<td>
							<?php echo $row->template_name; ?>
						</td>
						<td>
							<?php echo $row->logstamp; ?>
						</td>
						<td>
							<?php echo $user->name; ?>
						</td>
						<td>
							<?php echo $row->records; ?>
						</td>
						<td>
							<?php $run_cancelled = ($row->run_cancelled) ? JText::_('COM_CSVIVIRTUEMART_YES') : JText::_('COM_CSVIVIRTUEMART_NO'); 
							echo $run_cancelled;?>
						</td>
						<td>
							<?php echo $row->file_name; ?>
						</td>
						<td>
							<?php
							if (substr($row->action_type, -6) == 'import' || substr($row->action_type, -6) == 'export') {
								if (file_exists(CSVIPATH_DEBUG.'/com_csvivirtuemart.log.'.$row->run_id.'.php')) {
									$attribs = 'class="modal" onclick="" rel="{handler: \'iframe\', size: {x: 950, y: 500}}"';
									echo JHTML::_('link', JRoute::_('index.php?option=com_csvivirtuemart&view=log&task=logreader&tmpl=component&run_id='.$row->run_id), $row->run_id, $attribs);
								}
								else echo $row->run_id;
							}
							else echo $row->run_id;
							?>
						</td>
					</tr>
					<?php
				}
			}
			else echo '<tr><td colspan="10" class="center">'.JText::_('COM_CSVIVIRTUEMART_NO_LOG_ENTRIES_FOUND').'</td></tr>';
			?>
			</tbody>
		</table>
	</div>
	<input type="hidden" name="option" value="com_csvivirtuemart" />
	<input type="hidden" name="task" value="log" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" id="view" name="view" value="log" />
</form>
<script type="text/javascript">
	function submitbutton(pressbutton) {
		document.adminForm.task.value=pressbutton;
		if (pressbutton != 'logdetails') {
			if (pressbutton == 'remove') {
				var msg = '<?php echo JText::_('COM_CSVIVIRTUEMART_LOG_ARE_YOU_SURE_REMOVE');?>';
				var title = '<?php echo JText::_('COM_CSVIVIRTUEMART_DELETE');?>';
			}
			else if (pressbutton == 'remove_all') {       
				var msg = '<?php echo JText::_('COM_CSVIVIRTUEMART_LOG_ARE_YOU_SURE_REMOVE_ALL');?>';
				var title = '<?php echo JText::_('COM_CSVIVIRTUEMART_DELETE_ALL');?>';
			}
			jConfirm(msg, title, function(r) {
				if (r) submitform(pressbutton);
				else return false;
			})
		}
		else {
			jQuery('#view').val('logdetails');
			submitform(pressbutton);
		}
	}
	UpdateRowClass('logs');
</script>