<?php
/**
 * Import view
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: view.html.php 1591 2011-05-15 14:11:20Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.view' );

/**
 * Import View
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartViewImport extends JView {

	/**
	 * Import view display method
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function display($tpl = null) {
		// Set the template ID
		$session = JFactory::getSession();
		$option = JRequest::getVar('option');
		JRequest::setVar('template_id', JRequest::getInt('template_id', $session->get($option.'.select_template')));


		// Load the saved templates
		$template_model = $this->getModel('Templates');
		$this->lists['templates'] = JHtml::_('select.genericlist', $template_model->getTemplates('import'), 'select_template', '', 'value', 'text', JRequest::getInt('template_id'));

		// Load the selected template
		$item = $this->get('Template', 'templates');

		// Load the form handler
		$this->loadHelper('template');
		$this->template = new CsviTemplate($item);
		$app = JFactory::getApplication();
		$app->setUserState('com_csvivirtuemart.global.template', $this->template);

		// Load the general options
		$this->getOptions();

		// Load the image options
		$this->getImageOptions();

		// Get the toolbar title
		JToolBarHelper::title(JText::_( 'COM_CSVIVIRTUEMART_IMPORT' ), 'csvivirtuemart_import_48');

		// Get the toolbar
		JToolBarHelper::custom('cronline', 'csvivirtuemart_cron_32', 'csvivirtuemart_cron_32', JText::_('COM_CSVIVIRTUEMART_CRONLINE'), false);
		JToolBarHelper::custom( 'importfile', 'csvivirtuemart_import_32', 'csvivirtuemart_import_32', JText::_('COM_CSVIVIRTUEMART_IMPORT'), false);
		JToolBarHelper::help('import.html', true);

		// Display it all
		parent::display($tpl);
	}

	/**
	 * Get the general options
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return 		void
	 * @since 		3.0
	 */
	private function getOptions() {
		// Get the import types
		$template_model = $this->getModel('templates');
		$templatetypes = $template_model->getTemplateTypes('import');
		$this->lists['import_type'] = JHtml::_('select.genericlist', $templatetypes, 'jform[import_type]', '' , 'value', 'name', $this->template->getValue('import_type'), false, true);

		// Get the CSVI supported fields
		$availablefields_model = $this->getModel('availablefields');
		$csvisupportedfields = $availablefields_model->getAvailableFields($this->template->getValue('import_type', '', 'categorydetailsimport'));
		$this->assignRef('importfields', $csvisupportedfields);

		// Load the import fields
		$this->selectfields = array();
		foreach ($csvisupportedfields as $key => $fieldname) {
			$this->selectfields[] = JHtml::_('select.option', $fieldname, $fieldname);
		}
		$this->lists['importfields'] = JHtml::_('select.genericlist', $this->selectfields, '_field_name', null, 'value', 'text', null, '_field_name');

		// Create a place holder for the custom export tables
		$options = array();
		$this->showcustomtables = $this->template->getValue('custom_table_import', '', false);
		if ($this->showcustomtables) {
			$customtables = CsviHelper::getCustomTables();
			foreach ($customtables as $tblname) {
				$options[] = JHtml::_('select.option', $tblname, $tblname);
			}
		}
		$this->lists['customtables'] = JHtml::_('select.genericlist', $options, 'jform[custom_table_import]', '', 'value', 'text', $this->template->getValue('custom_table_import'));

		// Load the replacement fields
		$this->lists['replacementfields'] = JHtml::_('select.genericlist', $this->selectfields, '_field_name_replace', null, 'value', 'text', null, '_field_name_replace');

		// Load the product update options
		$options = array();
		$options[] = JHTML::_('select.option', 'product_sku', JText::_('COM_CSVIVIRTUEMART_PRODUCT_SKU'));
		$options[] = JHTML::_('select.option', 'product_mpn', JText::_('COM_CSVIVIRTUEMART_PRODUCT_MPN'));
		$options[] = JHTML::_('select.option', 'product_child_sku', JText::_('COM_CSVIVIRTUEMART_PRODUCT_CHILD_SKU'));
		$this->lists['update_based_on'] = JHTML::_('select.genericlist', $options, 'jform[product][update_based_on]', null , 'value', 'text', $this->template->getValue('update_based_on', 'product'), false, true);
	}

	/**
	 * The the image options
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.0
	 */
	private function getImageOptions() {
		// Get the thumbnail formats
		$options = array();
		$options[] = JHTML::_('select.option', 'none', 'DEFAULT');
		$options[] = JHTML::_('select.option', 'jpg', 'JPG');
		$options[] = JHTML::_('select.option', 'png', 'PNG');
		$options[] = JHTML::_('select.option', 'gif', 'GIF');

		$this->lists['thumbnailformat'] = JHTML::_('select.genericlist', $options, 'jform[image][thumb_extension]', null , 'value', 'text', $this->template->getValue('thumb_extension', 'image'), false, true);
		array_shift($options);
		array_unshift($options, JHTML::_('select.option', 'none', 'COM_CSVIVIRTUEMART_DO_NOT_CONVERT'));
		$this->lists['converttype'] = JHTML::_('select.genericlist', $options, 'jform[image][convert_type]', null , 'value', 'text', $this->template->getValue('convert_type', 'image'), false, true);
		array_shift($options);
		$this->lists['autogenerateext'] = JHTML::_('select.genericlist', $options, 'jform[image][auto_generate_image_name_ext]', null , 'value', 'text', $this->template->getValue('auto_generate_image_name_ext', 'image'), false, true);

		// Generate image name
		$options = array();
		$options[] = JHTML::_('select.option', 'product_sku', JText::_('COM_CSVIVIRTUEMART_PRODUCT_SKU'));
		$options[] = JHTML::_('select.option', 'product_name', JText::_('COM_CSVIVIRTUEMART_PRODUCT_NAME'));
		$options[] = JHTML::_('select.option', 'product_id', JText::_('COM_CSVIVIRTUEMART_PRODUCT_ID'));
		$options[] = JHTML::_('select.option', 'random', JText::_('COM_CSVIVIRTUEMART_RANDOM'));

		$this->lists['type_generate_image_name'] = JHTML::_('select.genericlist', $options, 'jform[image][type_generate_image_name]', null , 'value', 'text', $this->template->getValue('type_generate_image_name', 'image'), false, true);

		// Select case
		$options = array();
		$options[] = JHTML::_('select.option', 'none', JText::_('COM_CSVIVIRTUEMART_DO_NOT_CHANGE_CASE'));
		$options[] = JHTML::_('select.option', 'lcase', JText::_('COM_CSVIVIRTUEMART_SELECT_LCASE'));
		$options[] = JHTML::_('select.option', 'ucase', JText::_('COM_CSVIVIRTUEMART_SELECT_UCASE'));
		$options[] = JHTML::_('select.option', 'ucfirst', JText::_('COM_CSVIVIRTUEMART_SELECT_UCFIRST'));
		$options[] = JHTML::_('select.option', 'ucwords', JText::_('COM_CSVIVIRTUEMART_SELECT_UCWORDS'));

		$this->lists['change_case'] = JHTML::_('select.genericlist', $options, 'jform[image][change_case]', null , 'value', 'text', $this->template->getValue('change_case', 'image'), false, true);
	}
}
?>