<?php
/**
 * Export replacement page
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: default_replacement.php 1623 2011-09-28 17:39:57Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

$option = JRequest::getVar('option');
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_REPLACEMENT'); ?></legend>
	<div id="export_fields">
		<table id="newfieldlist_replace" class="adminlist">
			<thead>
				<tr>
					<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_FIELD_NAME'); ?></th>
					<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_OLD_VALUE'); ?></th>
					<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_NEW_VALUE'); ?></th>
					<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_TYPE'); ?></th>
					<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_ADD_FIELD'); ?></th>
			</thead>
			<tfoot>
				<tr>
					<td colspan="5"></td>
				</tr>
			</tfoot>
			<tbody>
				<tr>
					<!-- Field -->
					<td>
						<?php echo $this->lists['replacementfields']; ?>
					</td>
					<!-- Find -->
					<td>
						<input type="text" class="replaceinput" name="_old_value" id="_old_value" value="" />
					</td>
					<!-- Replace -->
					<td>
						<input type="text" class="replaceinput" name="_new_value" id="_new_value" value="" />
					</td>
					<!-- Regex? -->
					<td>
						<?php echo JHtml::_('select.booleanlist', '_replace_type', '', '1', JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_REGEX'), JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_REGULAR'), '_regex'); ?>
					</td>
					<!-- Add -->
					<td>
						<?php echo JHTML::_('link', '#', JHTML::_('image', JURI::root().'administrator/components/'.$option.'/assets/images/csvivirtuemart_add_16.png', JText::_('COM_CSVIVIRTUEMART_ADD')), array('id' => 'addRow_replace')); ?>
					</td>
				</tr>
			</tbody>
		</table>
		<br />
		<table id="fieldslist_replace" class="adminlist">
			<thead>
			<tr class="nodrag">
				<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_FIELD_NAME'); ?></th>
				<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_OLD_VALUE'); ?></th>
				<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_NEW_VALUE'); ?></th>
				<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_TYPE'); ?></th>
				<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_DELETE'); ?></th>
			</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="5"></td>
				</tr>
			</tfoot>
			<tbody>
				<?php
					$replace_fields = $this->template->getValue('replacement_export_fields', '', array());
					if (isset($replace_fields['_selected_name'])) {
						$count = count($replace_fields['_selected_name']);
						for ($rows = 0; $rows < $count; $rows++) {
							$id = mt_rand();
							?>
							<tr>
								<td>
								<?php echo JHtml::_('select.genericlist', $this->advanced_csvifields, 'jform[replacement_export_fields][_selected_name][]', null, 'value', 'text', $replace_fields['_selected_name'][$rows]); ?></td>
								<td><input class="replaceinput" type="text" name="jform[replacement_export_fields][_old_value][]" value="<?php echo htmlspecialchars($replace_fields['_old_value'][$rows]); ?>" /></td>
								<td><input class="replaceinput" type="text" name="jform[replacement_export_fields][_new_value][]" value="<?php echo htmlspecialchars($replace_fields['_new_value'][$rows]); ?>" /></td>
								<td><?php echo JHtml::_('select.booleanlist', 'jform[replacement_export_fields][_replace_type]['.$rows.']', '', $replace_fields['_replace_type'][$rows], JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_REGEX'), JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_REGULAR'), '_field_name_replace'.$id); ?></td>
								<td><?php echo JHtml::_('link', 'index.php?option='.$option.'&view=export', JHtml::_('image', JURI::root().'/administrator/components/'.$option.'/assets/images/csvivirtuemart_delete_32.png', 'width="20" height="20" border="0" alt="'.JText::_('COM_CSVIVIRTUEMART_DELETE').'"'), 'onclick="jQuery(this).parents(\'tr\').remove(); jQuery(\'#fieldslist_replace\').tableDnD(); return false;"'); ?></td>
							</tr>
							<?php
						}
					}
				?>
			</tbody>
		</table>
	</div>
</fieldset>

<script type="text/javascript">
jQuery(document).ready(function() {
    jQuery("#fieldslist_replace").tableDnD();
});

jQuery("#addRow_replace").click(function() {
	var remove_image 	= '<img src="<?php echo JURI::root().'/administrator/components/'.$option.'/assets/images/csvivirtuemart_delete_32.png'; ?>" width="20" height="20" border="0" alt="<?php echo JText::_('COM_CSVIVIRTUEMART_DELETE'); ?>" />';
	var remove_link 	= '<a href="index.php?option=<?php echo $option; ?>&view=export" onclick="jQuery(this).parents(\'tr\').remove(); jQuery(\'#fieldslist_replace\').tableDnD(); return false;">'+remove_image+'</a>';
	var old_value	 	= '<input class="replaceinput" type="text" name="jform[replacement_export_fields][_old_value][]" value="'+jQuery('#_old_value').val()+'" />';
	var new_value	 	= '<input class="replaceinput" type="text" name="jform[replacement_export_fields][_new_value][]" value="'+jQuery('#_new_value').val()+'" />';
	var field_name	 	= '<input type="text" name="jform[replacement_export_fields][_selected_name][]" value="'+jQuery('#_field_name_replace').val()+'" readonly="readonly" size="35" />';
	var rows = jQuery("#fieldslist_replace tbody").children().size();
	if (jQuery("input[name='_replace_type']:checked").val() == 1) {
		var regex		= '<input type="radio" value="0" id="_replace_type'+rows+'" name="jform[replacement_export_fields][_replace_type]['+rows+']"><label for="_regex'+rows+'"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_REGULAR'); ?></label><input type="radio" checked="checked" value="1" id="_replace_type'+(rows+1)+'" name="jform[replacement_export_fields][_replace_type]['+rows+']"><label for="_replace_type'+(rows+1)+'"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_REGEX'); ?></label>';
	}
	else {
		var regex		= '<input type="radio" checked="checked" value="0" id="_replace_type'+rows+'" name="jform[replacement_export_fields][_replace_type]['+rows+']"><label for="_regex'+rows+'"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_REGULAR'); ?></label><input type="radio" value="1" id="_replace_type'+(rows+1)+'" name="jform[replacement_export_fields][_replace_type]['+rows+']"><label for="_replace_type'+(rows+1)+'"><?php echo JText::_('COM_CSVIVIRTUEMART_REPLACEMENT_REGEX'); ?></label>';
	}
	var tr = '<tr><td>'+field_name+'</td><td>'+old_value+'</td><td>'+new_value+'</td><td>'+regex+'</td><td>'+remove_link+'</td></tr>';
	var $table = jQuery("#fieldslist_replace");
	var $tableBody = jQuery("tbody", $table);
	newRow = jQuery(tr).appendTo($tableBody);
	jQuery("#fieldslist_replace").tableDnD();
	return false;
});
</script>