<?php
/**
 * VMF values products table
 *
 * @package		CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: custom_table.php 1543 2011-03-08 08:49:57Z RolandD $
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * @package CSVIVirtueMart
 */
class TableVmf_values_products extends JTable {

	// Sets whether the database columns have been loaded
	private $_loaded = false;

	/**
	 * Method Description
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param 		$db	object	A database connector object
	 * @return
	 * @since 		3.0
	 */
	public function __construct($db) {
		$this->reset();
		parent::__construct('#__vmfprodsubcategory', 'prod_vmf_id', $db);
	}

	/**
	* Set a value for the class
	 */
	public function setValue($field, $value) {
		$this->$field = $value;
	}

	/**
	* Get a value from the class
	 */
	public function getValue($field) {
		return $this->$field;
	}

	/**
	 * Resets the default properties
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		void
	 * @since 		3.5
	 */
	public function reset() {
		if (!$this->_loaded) {
			$this->setProperties(CsvivirtuemartModelAvailablefields::DbFields('vmfprodsubcategory'));
			$this->_loaded = true;
		}
		else {
			$class_vars = get_class_vars(get_class($this));
			foreach ($this as $name => $value) {
				if (substr($name, 0, 1) != '_') {
					$this->$name = null;
				}
			}
		}
	}

	/**
	 * Check if the feature already exists
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		bool	true if feature exists | false if feature does not exist
	 * @since 		3.5
	 */
	public function check() {
		$db = JFactory::getDbo();
		$q = "SELECT ".$this->_tbl_key.
			" FROM ".$this->_tbl.
			" WHERE ".$db->nameQuote('product_id')." = ".$db->Quote($this->product_id).
			" AND ".$db->nameQuote('ids')." = ".$db->Quote($this->ids);
		$db->setQuery($q);
		$id = $db->loadResult();
		if ($id) {
			$this->setValue('prod_vmf_id', $id);
			return true;
		}
		else return false;
	}
}
?>