<?php
/**
 * VMF features cross reference VM category table
 *
 * @package		CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: custom_table.php 1543 2011-03-08 08:49:57Z RolandD $
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * @package CSVIVirtueMart
 */
class TableVmf_features_xref extends JTable {

	// Sets whether the database columns have been loaded
	private $_loaded = false;

	/**
	 * Method Description
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param 		$db	object	A database connector object
	 * @return
	 * @since 		3.0
	 */
	public function __construct($db) {
		$this->reset();
		parent::__construct('#__vmfcat_vmcat_xref', 'vmf_cat', $db);
	}

	/**
	* Set a value for the class
	 */
	public function setValue($field, $value) {
		$this->$field = $value;
	}

	/**
	* Get a value from the class
	 */
	public function getValue($field) {
		return $this->$field;
	}

	/**
	* Resets the default properties
	* @return	void
	 */
	public function reset() {
		if (!$this->_loaded) {
			$this->setProperties(CsvivirtuemartModelAvailablefields::DbFields('vmfcat_vmcat_xref'));
			$this->_loaded = true;
		}
		else {
			$class_vars = get_class_vars(get_class($this));
			foreach ($this as $name => $value) {
				if (substr($name, 0, 1) != '_') {
					$this->$name = null;
				}
			}
		}
	}

	/**
	 * Check if an entry already exists
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.5
	 */
	public function check() {
		// Check if there is already an entry in the database
		$q = "SELECT COUNT(".$this->_db->Quote('vmf_cat').")
			FROM ".$this->_db->nameQuote($this->_tbl)."
			WHERE ".$this->_db->nameQuote('vmf_cat')." = ".$this->_db->Quote($this->vmf_cat)."
			AND ".$this->_db->nameQuote('vm_cat')." = ".$this->_db->Quote($this->vm_cat);
		$this->_db->setQuery($q);
		$result = $this->_db->loadResult();
		if ($result > 0) return true;
		else return false;
	}

	/**
	 * Store the category references
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		true if store is success | false if store failed
	 * @since 		3.5
	 */
	public function store() {
		$ret = $this->_db->insertObject( $this->_tbl, $this, $this->_tbl_key );
		if( !$ret )
		{
			$this->setError(get_class( $this ).'::store failed - '.$this->_db->getErrorMsg());
			return false;
		}
		else
		{
			return true;
		}
	}
}
?>