<?php
/**
 * Virtuemart User Info table
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: vm_user_info.php 1517 2011-02-27 07:00:37Z RolandD $
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * @package CSVIVirtueMart
 */
class TableVm_user_info extends JTable {
	
	// Sets whether the database columns have been loaded
	private $_loaded = false;
	
	/**
	* @param database A database connector object
	 */
	function __construct($db) {
		$this->reset();
		parent::__construct('#__vm_user_info', 'user_info_id', $db );
	}
	
	/**
	* Resets the default properties
	* @return	void
	 */
	function reset() {
		if (!$this->_loaded) {
			$this->setProperties(CsvivirtuemartModelAvailablefields::DbFields('vm_user_info'));
			$this->_loaded = true;
		}
		else {
			$class_vars = get_class_vars(get_class($this));
			foreach ($this as $name => $value) {
				if (substr($name, 0, 1) != '_') {
					$this->$name = null;
				}
			}
		}
	}
	
	/**
	* Stores user information
	 */
	public function store() {
		$db = JFactory::getDBO();
		
		if($this->check()) {
			$ret = $db->updateObject( $this->_tbl, $this, $this->_tbl_key, false );
		}
		else {
			$ret = $db->insertObject( $this->_tbl, $this, $this->_tbl_key );
		}
		if(!$ret) {
			$this->setError(get_class( $this ).'::store failed - '.$db->getErrorMsg());
			return false;
		}
		else  return true;
	}
	
	/**
	* Check if user info already exists 
	*
	* Criteria for existing user info:
	* - user_id
	* - address_type
	* - address_type_name
	 */
	public function check() {
		// See if we already have user_info_id
		if (empty($this->user_info_id)) {
			$db = JFactory::getDBO();
			$csvilog = JRequest::getVar('csvilog');
			
			// Check if a record already exists in the database
			$q = "SELECT ".$this->_tbl_key."
				FROM ".$this->_tbl."
				WHERE user_id = '".$this->user_id."'
				AND address_type = '".$this->address_type."' 
				AND address_type_name = ".$db->Quote($this->address_type_name);
			$db->setQuery($q);
			$db->query($q);
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_CHECKING_USER_EXISTS'), true);
			if ($db->getAffectedRows() > 0) {
				$this->user_info_id = $db->loadResult();
				return true;
			}
			else {
				// There is no entry yet, so we must insert a new one
				$this->user_info_id = md5(uniqid(rand(), true));
				return false;
			}
		}
		// There is already a user_info_id, only update the record
		else return true;
	}
}
?>