<?php
/**
 * Virtuemart Product Type table
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: vm_product_type_x.php 1524 2011-03-04 13:28:14Z RolandD $
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * @package CSVIVirtueMart
 */
class TableVm_product_type_x extends JTable {
	
	// Sets whether the database columns have been loaded
	private $_loaded = false;
	
	/**
	* @param database A database connector object
	 */
	function __construct($db) {
		$this->reset();
		parent::__construct('#__vm_product_type', 'product_id', $db );
	}
	
	/**
	* Set a value for the class
	 */
	public function setValue($field, $value) {
		$this->$field = $value;
	}
	
	/**
	* Get a value from the class
	 */
	public function getValue($field) {
		return $this->$field;
	}
	
	/**
	* Resets the default properties
	* @return	void
	 */
	function reset() {
		if (!$this->_loaded) {
			$this->setProperties(CsvivirtuemartModelAvailablefields::DbFields(str_replace('#__', '', $this->_tbl)));
			$this->_loaded = true;
		}
		else {
			$class_vars = get_class_vars(get_class($this));
			foreach ($this as $name => $value) {
				if (substr($name, 0, 1) != '_') {
					$this->$name = null;
				}
			}
		}
	}
	
	/**
	 * Store the product type names 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function store() {
		$db = JFactory::getDBO();
		$csvilog = JRequest::getVar('csvilog');
		
		// Check if the product type ID already exists
		$q = "SELECT COUNT(product_id) AS products 
			FROM ".$this->_tbl." 
			WHERE product_id = '".$this->product_id."'";
		$db->setQuery($q);
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_DEBUG_CHECK_PRODUCT_TYPE_ID_EXISTS'), true);
		$product_type_exists = $db->loadResult();
		
		// Variable used for reporting query type
		if ($product_type_exists > 0) {
			$q = "UPDATE ".$this->_tbl." ";
			$q .= "SET ";
			
			foreach ($this->details as $colname => $value) {
				$colname = strtolower($colname);
				$q .= $db->nameQuote($colname)." = ".$db->Quote($value).",";
			}
			$q = substr($q, 0, -1)." ";
			$q .= "WHERE product_id = ".$this->product_id;
			$action = 'updated';
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_DEBUG_UPDATING_NEW_PRODUCT_TYPE_DETAILS'));
		}	
		else {
			$q = "INSERT INTO ".$this->_tbl." ";
			$q .= "(";
			$qfields = $db->nameQuote('product_id').',';
			$qvalues = $db->Quote($this->product_id).',';
			
			foreach ($this->details as $colname => $value) {
				$colname = strtolower($colname);
				$qfields .= $db->nameQuote($colname).',';
				$qvalues .= $db->Quote($value).',';
				
			}
			$q .= substr($qfields, 0, -1);
			$q .= ") VALUES (";
			$q .= substr($qvalues, 0, -1);
			$q .= ")";
			$action = 'added';
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_DEBUG_ADDING_NEW_PRODUCT_TYPE_DETAILS'));
		}
		$db->setQuery($q);
		if ($db->query()) {
			$csvilog->addDebug(JText::sprintf('COM_CSVIVIRTUEMART_UPDATE_PRODUCT_TYPE_X', $this->product_type_id), true);
			$csvilog->AddStats($action, JText::sprintf('COM_CSVIVIRTUEMART_PRODUCT_TYPE_DETAIL_SKU_ID', $this->identify));
		}
		else {
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_DEBUG_PRODUCT_TYPE_NAMES_STORE_FAILED'), true);
			$csvilog->AddStats('incorrect', JText::_('COM_CSVIVIRTUEMART_PRODUCT_TYPE_NAMES_NOT_STORED'));
		}
	}
}
?>