<?php
/**
 * Custom table
 *
 * @package		CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: custom_table.php 1543 2011-03-08 08:49:57Z RolandD $
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * @package CSVIVirtueMart
 */
class TableCustom_table extends JTable {
	
	// Sets whether the database columns have been loaded
	private $_loaded = false;
	
	/**
	 * Method Description 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 		$db	object	A database connector object 
	 * @return 
	 * @since 		3.0
	 */
	public function __construct($db) {
		$this->reset();
		$template = JRequest::getVar('template');
		// Find which table we are importing
		$tbl = $template->getValue('custom_table_import');
		// Find the primare key for this table
		$pk = CsviHelper::getPrimaryKey($tbl);
		parent::__construct('#__'.$tbl, $pk, $db);
	}
	
	/**
	* Set a value for the class
	 */
	public function setValue($field, $value) {
		$this->$field = $value;
	}
	
	/**
	* Get a value from the class
	 */
	public function getValue($field) {
		return $this->$field;
	}
	
	/**
	* Resets the default properties
	* @return	void
	 */
	public function reset() {
		if (!$this->_loaded) {
			$template = JRequest::getVar('template');
			$tbl = $template->getValue('custom_table_import');
			$this->setProperties(CsvivirtuemartModelAvailablefields::DbFields($tbl));
			$this->_loaded = true;
		}
		else {
			$class_vars = get_class_vars(get_class($this));
			foreach ($this as $name => $value) {
				if (substr($name, 0, 1) != '_') {
					$this->$name = null;
				}
			}
		}
	}
}
?>