<?php
/**
 * VMF features import
 *
 * @package		CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: customimport.php 1556 2011-03-24 16:16:54Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Processor for VMF features imports
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelVmf_featuresimport extends CsvivirtuemartModelImportfile {

	// Private tables
	private $_vmf_features = null;
	private $_vmf_features_xref = null;

	// Public variables
	/** @var int the feature ID */
	public $vmf_cat = 0;

	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	/** @var object contains general import functions */
	private $_importmodel = null;
	/** @object contains the category model */
	private $_categorymodel = null;

	/**
	 * Constructor
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }

	/**
	 * Here starts the processing
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getStart() {
		// Load the data
		$this->loadData();

		// Get the logger
		$csvilog = JRequest::getVar('csvilog');

		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;

					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						// Check if the field needs extra treatment
						switch ($name) {
							case 'category_path':
								if (strlen(trim($this->_datafield)) > 0) {
									if (stripos($this->_datafield, '|') > 0) $category_ids[$name] = explode("|", $this->_datafield);
									else $category_ids[$name][] = $this->_datafield;
									$this->category_ids = $category_ids;
								}
								$this->$name = $this->_datafield;
								break;
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else return false;
			}
		}
		return true;
	}

	/**
	 * Process each record and store it in the database
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getProcessRecord() {
		// Get the imported values
		$csvilog = JRequest::getVar('csvilog');
		$db = JFactory::getDBO();

		// Process category path
		if (isset($this->category_path)) {
			if (is_null($this->_categorymodel)) $this->_categorymodel = new CsvivirtuemartModelCategory();
			$this->_categorymodel->getStart();
			$catid = $this->_categorymodel->getCategoryIdFromPath($this->category_path);
			$this->vm_cat = $catid['category_id'];
		}

		// Bind the data
		$this->_vmf_features->bind($this);

		// Check the data
		$this->_vmf_features->check();

		// Reset the category since it is used on another table
		$this->_vmf_features->setValue('vm_cat', 0);

		// Store the data
		if ($this->_vmf_features->store()) {
			if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_VMF_FEATURES'));
			else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_VMF_FEATURES'));
			$this->vmf_cat = $this->_vmf_features->getValue('id');
		}
		else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_VMF_FEATURES_NOT_ADDED', $this->_vmf_features->getError()));

		// Store the debug message
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_VMF_FEATURES_QUERY'), true);

		// See if there is a feature ID
		if ($this->vmf_cat > 0) {
			// Store the category relation
			$this->_vmf_features_xref->bind($this);

			// Store the data
			if (!$this->_vmf_features_xref->check()) {
				if ($this->_vmf_features_xref->store()) {
					if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_VMF_FEATURES_XREF'));
					else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_VMF_FEATURES_XREF'));
				}
				else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_VMF_FEATURES_XREF_NOT_ADDED', $this->_vmf_features_xref->getError()));
			}

			// Store the debug message
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_VMF_FEATURES_XREF_QUERY'), true);
		}

		// Clean the tables
		$this->cleanTables();
	}

	/**
	 * Load the necessary tables
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.0
	 */
	private function _loadTables() {
		$this->_vmf_features = $this->getTable('vmf_features');
		$this->_vmf_features_xref = $this->getTable('vmf_features_xref');
	}

	/**
	 * Cleaning the tables
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		protected
	 * @param
	 * @return
	 * @since 		3.0
	 */
	protected function cleanTables() {
		$this->_vmf_features->reset();
		$this->_vmf_features_xref->reset();

		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}
}
?>