<?php
/**
 * Product type parameters import
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: producttypeparametersimport.php 1599 2011-06-22 08:25:08Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Processor for product type parameters
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelProducttypeparametersimport extends CsvivirtuemartModelImportfile {

	// Private tables
	/** @var object contains the vm_product_files table */
	private $_vm_product_type_parameter = null;

	// Public variables
	/** @var integer contains the ID for the product type */
	public $product_type_id = null;
	/** @var string contains the parameter multi-select setting */
	public $parameter_multiselect = 'N';
	/** @var string contains the parameter multi-select values */
	public $parameter_values = null;
	/** @var string contains the parameter multi-select values */
	public $product_type_parameter_delete = 'N';

	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	/** @var object contains general import functions */
	private $_importmodel = null;

	/**
	 * Constructor
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }

	/**
	 * Here starts the processing
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo		Multi-select option check
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getStart() {
		// Load the data
		$this->loadData();

		// Get the logger
		$csvilog = JRequest::getVar('csvilog');

		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;

					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						// Check if the field needs extra treatment
						switch ($name) {
							case 'parameter_name':
								$this->parameter_name = str_replace(" ", "_", $this->_datafield);
								break;
							case 'parameter_label':
								$this->parameter_label = $this->_datafield;
								break;
							case 'parameter_description':
								$find = array("\r\n", "\n");
								$replace = array("", "");
								$this->parameter_description = str_replace($find, $replace, $this->_datafield);
								break;
							case 'parameter_list_order':
								$this->parameter_list_order = $this->_datafield;
								break;
							case 'parameter_type':
								$this->parameter_type = strtoupper($this->_datafield);
								break;
							case 'parameter_values':
								// Strip a trailing ;
								if (';' == substr($this->_datafield, -1)) $this->_datafield = substr($this->_datafield, 0, -1);
								$this->parameter_values = $this->_datafield;
								break;
							case 'parameter_multiselect':
								$this->parameter_multiselect = strtoupper($this->_datafield);
								break;
							case 'parameter_default':
								$this->parameter_default = $this->_datafield;
								break;
							case 'parameter_unit':
								$this->parameter_unit = $this->_datafield;
								break;
							case 'parameter_delete':
								$this->$name = strtoupper($this->_datafield);
								break;
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else return false;
			}
		}
		// Check if we have a parameter name
		if (isset($this->parameter_name)) {
			// Get the product type ID
			if (is_null($this->product_type_id)) $this->product_type_id = $this->getProductTypeId($this->product_type_name);
			if ($this->product_type_id) {
				if( $this->parameter_multiselect == "Y" && (!isset($this->parameter_values) || $this->parameter_values == "" )) {
					$csvilog->AddStats('incorrect', JText::_('COM_CSVIVIRTUEMART_NO_PARAMETER_VALUES'));
					return false;
				}
				// Check the list order
				$this->_productTypeParameterListOrder();
			}
			else {
				$csvilog->AddStats('incorrect', JText::_('COM_CSVIVIRTUEMART_NO_PRODUCT_ID'));
				return false;
			}
		}
		else {
			$csvilog->AddStats('incorrect', JText::_('COM_CSVIVIRTUEMART_NO_PARAMETER_NAME'));
			return false;
		}

		// Check for a breakline
		if (empty($this->parameter_label)) {
			if (isset($this->parameter_type) && $this->parameter_type == "B")
				$this->parameter_label = $this->parameter_name;
		}

		// Check the multi-select option
		if ($this->parameter_multiselect == "Y" && is_null($this->parameter_values)) {
			// $csvilog->addDebug("ERROR:  If You checked Multiple select you must enter a Possible Values.");
			return false;
		}
		return true;
	}

	/**
	 * Process each record and store it in the database
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getProcessRecord() {
		$csvilog = JRequest::getVar('csvilog');

		// Bind the data
		$this->_vm_product_type_parameter->bind($this);

		// Check if we need to store or delete the entry
		if ($this->product_type_parameter_delete == 'Y') {
			// Delete the parameter
			$this->_vm_product_type_parameter->delete();
		}
		else {
			// Store the data
			if ($this->_vm_product_type_parameter->store()) {
				if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_PRODUCTTYPEPARAMETER'));
				else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_PRODUCTTYPEPARAMETER'));
			}
			else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_PRODUCTTYPEPARAMETER_NOT_ADDED', $this->_vm_product_type_parameter->getError()));

			// Store the debug message
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_PRODUCTTYPEPARAMETER_QUERY'), true);
		}

		// Clean the tables
		$this->cleanTables();
	}

	/**
	 * Load the product type parameters related tables
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.0
	 */
	private function _loadTables() {
		$this->_vm_product_type_parameter = $this->getTable('vm_product_type_parameter');
	}

	/**
	 * Cleaning the product type parameters related tables
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		protected
	 * @param
	 * @return
	 * @since 		3.0
	 */
	protected function cleanTables() {
		$this->_vm_product_type_parameter->reset();

		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}

	/**
	 * Get the highest list order and add 1 for the new list order
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.0
	 */
	private function _productTypeParameterListOrder() {
		$db = JFactory::getDBO();

		if (!isset($this->parameter_list_order) || $this->parameter_list_order == 0) {
			$q = "SELECT MAX(parameter_list_order) AS list_order
				FROM #__vm_product_type_parameter
				WHERE product_type_id = ".$this->product_type_id;
			$db->setQuery($q);
			$db->query();
			$this->parameter_list_order = $db->loadResult()+1;
		}
	}
}
?>