<?php
/**
 * Manufacturer category import
 *
 * @package		CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: manufacturercategoryimport.php 1593 2011-05-25 12:30:12Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Processor for manufacturer categories
 *
 * Main processor for handling manufacturer categories
 *
 * @package CSVIVirtueMart
 * @todo	Remove images
 * @todo	check update null fields
 */
class CsvivirtuemartModelManufacturercategoryimport extends CsvivirtuemartModelImportfile {
	
	// Private tables
	/** @var object contains the csvi_templates table */
	private $_vm_manufacturer_category = null;
	
	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	
	// Public variables
	public $mf_category_delete = 'N';
	
	/**
	 * Constructor 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }
	
	/**
	 * Here starts the processing 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function getStart() {
		// Load the data
		$this->loadData();
		
		// Get the statistics
		$csvilog = JRequest::getVar('csvilog');
		
		// Check if either the manufacturer category ID or manufacturer category name has been specified
		if (!isset($this->_csvifields['manufacturer_category_id']) && !isset($this->_csvifields['manufacturer_category_name'])) {
			$csvilog->AddStats('incorrect', JText::_('COM_CSVIVIRTUEMART_NO_MANUFACTURER_ID_NAME'));
			return false;
		}
		
		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;
					
					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						switch($name) {
							case 'manufacturer_category_id':
								$this->$name = $this->mf_category_id = $this->_datafield;
								break;
							case 'manufacturer_category_name':
								$this->$name = $this->mf_category_name = $this->_datafield;
								break;
							case 'manufacturer_category_desc':
								$this->$name = $this->mf_category_desc = $this->_datafield;
								break;
							case 'manufacturer_category_delete':
								$this->$name = $this->mf_category_delete = strtoupper($this->_datafield);
								break;
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else  return false;
			}
		}
		return true;
	}
	
	/**
	 * Process each record and store it in the database 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function getProcessRecord() {
		$csvilog = JRequest::getVar('csvilog');
		$template = JRequest::getVar('template');
		
		// Check if we have a manufacturer category ID, if not get it
		if (!isset($this->mf_category_id)) $this->mf_category_id = $this->_getManufacturerCategoryId();
		
		// Bind the data
		$this->_vm_manufacturer_category->bind($this);
		
		// User wants to delete the manufacturer
		if ($this->mf_category_id && $this->mf_category_delete == "Y") {
			if ($this->_vm_manufacturer_category->delete($this->mf_category_id)) {
				$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_DELETE_MANUFACTURER_CATEGORY'), true);
				$csvilog->AddStats('deleted', JText::_('COM_CSVIVIRTUEMART_MANUFACTURER_CAT_DELETED'));
			}
			else $csvilog->AddStats('error', JText::sprintf('COM_CSVIVIRTUEMART_MANUFACTURER_CAT_NOT_DELETED', $this->_vm_manufacturer_category->getError()));
		}
		else if (!$this->mf_category_id && $template->getValue('ignore_non_exist', 'general')) {
			// Do nothing for new products when user chooses to ignore new products
			if (isset($this->mf_category_name)) $value = $this->mf_category_name;
			else $value = '';
			$csvilog->AddStats('skipped', JText::sprintf('COM_CSVIVIRTUEMART_IGNORE_NON_EXIST_DATA', $value));
		}
		// User wants to add or update the manufacturer category
		else {
			if ($this->_vm_manufacturer_category->store()) {
				if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_MANUFACTURER_CATEGORY'));
				else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_MANUFACTURER_CATEGORY'));
			}
			else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_MANUFACTURER_CATEGORY_NOT_ADDED', $this->_vm_manufacturer_category->getError()));
			
			// Store the debug message
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_MANUFACTURER_CATEGORY_QUERY'), true);
		}
		
		// Clean the tables
		$this->cleanTables();
	}
	
	/**
	 * Load the manufacturer category related tables 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		private
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	private function _loadTables() {
		$this->_vm_manufacturer_category = $this->getTable('vm_manufacturer_category');
	}
	
	/**
	 * Cleaning the manufacturer related related tables 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		protected
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	protected function cleanTables() {
		$this->_vm_manufacturer_category->reset();
		
		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}
	
	/**
	 * Get the manufacturer category ID 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		private
	 * @param 
	 * @return 		mixed	integer when category ID found | false when not found
	 * @since 		3.0
	 */
	private function _getManufacturerCategoryId() {
		$db = JFactory::getDBO();
		$csvilog = JRequest::getVar('csvilog');
		$q = "SELECT mf_category_id
			FROM #__vm_manufacturer_category
			WHERE mf_category_name  = ".$db->Quote($this->mf_category_name);
		$db->setQuery($q);
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_FIND_MANUFACTURER_CATEGORY_ID'), true);
		if ($db->query()) return $db->loadResult();
		else return false;
	}
}
?>