<?php
/**
 * Import controller
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 * @version 	$Id: import.php 1553 2011-03-22 14:54:32Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport('joomla.application.component.controller');

/**
 * Import Controller
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartControllerImport extends JController {
	
	/**
	 * Constructor 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function __construct() {
		parent::__construct();
		
		$this->registerTask('load','import');
		$this->registerTask('saveasnew','save');
	}
	
	/**
	 * Shows the import option screen 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function import() {
		// Create the view object
		$view = $this->getView('import', 'html');
		
		// Standard model
		$view->setModel( $this->getModel( 'import', 'CsvivirtuemartModel' ), true );
		// Templates model
		$view->setModel( $this->getModel( 'templates', 'CsvivirtuemartModel' ));
		// Available fields model
		$view->setModel( $this->getModel( 'availablefields', 'CsvivirtuemartModel' ));
		
		// Now display the view
		$view->display();
	}
	
	/**
	 * Save import settings  
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		void
	 * @since 		3.0
	 */
	public function save() {
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
		$model = $this->getModel('templates');
		
		// Store the form fields
		$app	= JFactory::getApplication();
		$data	= JRequest::getVar('jform', array(), 'post', 'array');
		
		// Re-order the advanced fields
		if (array_key_exists('import_fields', $data)) {
			$fields = array();
			foreach ($data['import_fields']['_process_field'] as $field) {
				$fields[] = $field;
			}
			$data['import_fields']['_process_field'] = $fields;
			
			// Combine field
			$fields = array();
			foreach ($data['import_fields']['_combine_field'] as $field) {
				$fields[] = $field;
			}
			$data['import_fields']['_combine_field'] = $fields;
			
			// Re-order the replacement fields
			$fields = array();
			foreach ($data['replacement_import_fields']['_replace_type'] as $field) {
				$fields[] = $field;
			}
			$data['replacement_import_fields']['_replace_type'] = $fields;
		}
		
		// Save the data
		$id = $model->save($data, 'import');
		
		// Redirect back to the export page
		$this->setRedirect(JRoute::_('index.php?option=com_csvivirtuemart&view=import&task=import&template_id='.$id, false));
	}
	
	/**
	 * Remove an import template  
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		void
	 * @since 		3.0
	 */
	public function remove() {
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
		$model = $this->getModel('templates');
		
		// Save the data
		$model->remove('import');
		
		// Redirect back to the export page
		$this->setRedirect(JRoute::_('index.php?option=com_csvivirtuemart&view=import&task=import', false));
	}
	
	/**
	 * Import is all finished, show the results page 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function finished() {
		// Create the view object
		$view = $this->getView('import', 'result');
		
		// Standard model
		$view->setModel( $this->getModel( 'import', 'CsvivirtuemartModel' ), true );
		
		// Log functions
		$view->setModel( $this->getModel( 'log', 'CsvivirtuemartModel' ));
		
		// Set the layout file
		$view->setLayout('import_result');
		
		// Now display the view
		$view->display();
	}
	
	/**
	 * Cancel a running import 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return
	 * @since 		3.0
	 */
	public function cancelImport() {
		if (JRequest::getBool('was_preview')) {
			$this->setRedirect('index.php?option='.JRequest::getCmd('option').'&view=import', JText::_('COM_CSVIVIRTUEMART_IMPORT_CANCELLED'), 'notice');
		}
		else {
			// Load the data from the session
			$session = JFactory::getSession();
			$option = JRequest::getVar('option');
			
			// The template
			$template = unserialize($session->get($option.'.global.template'));
			if (is_object($template)) {
				// Enable the session
				JRequest::setVar('importsession', true);
				
				// Set the template
				JRequest::setVar('template', $template);
				// The logger
				JRequest::setVar('csvilog', unserialize($session->get($option.'.csvilog')));
				// Set the file handler
				JRequest::setVar('csvifile', unserialize($session->get($option.'.csvifile')));
				// Load the total line counter
				JRequest::setVar('totalline', unserialize($session->get($option.'.totalline')));
				// Load the total of records processed
				JRequest::setVar('recordsprocessed', unserialize($session->get($option.'.recordsprocessed')));
				// Load the field settings
				JRequest::setVar('csvifields', unserialize($session->get($option.'.csvifields')));
				// Load the column headers
				JRequest::setVar('columnheaders', unserialize($session->get($option.'.csvicolumnheaders')));
				// Load the preview handler
				JRequest::setVar('csvipreview', unserialize($session->get($option.'.csvipreview')));
				// Load the settings
				JRequest::setVar('csvisettings', unserialize($session->get($option.'.csvisettings')));
				
				// Finish the process
				$model = $this->getModel('importfile');
				$model->finishProcess(true);
			}
			
			// Store the import as cancelled
			$db = JFactory::getDBO();
			$q = "UPDATE #__csvivirtuemart_logs SET run_cancelled=1 WHERE id=".JRequest::getInt('log_id'); 
			$db->setQuery($q);
			$db->query();
			// Return to the import result screen
			$this->setRedirect('index.php?option='.JRequest::getCmd('option').'&view=import&task=import&import_id='.JRequest::getInt('import_id'), JText::_('COM_CSVIVIRTUEMART_IMPORT_CANCELLED'), 'notice');
		}
	}
}
?>